/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class DelegatingResourceManager
implements ResourceManager {
    private final List<ResourceManager> delegates;

    public DelegatingResourceManager(ResourceManager ... delegates) {
        this.delegates = Arrays.asList(delegates);
    }

    public Resource getResource(String path) throws IOException {
        for (ResourceManager i : this.delegates) {
            Resource res = i.getResource(path);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void close() throws IOException {
        for (ResourceManager i : this.delegates) {
            i.close();
        }
    }
}

