/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.util.UriNormalizationUtil;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.devmode.console.ConfiguredPathInfo;
import io.quarkus.vertx.http.runtime.BasicRoute;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;

public final class HttpRootPathBuildItem
extends SimpleBuildItem {
    private final URI rootPath;

    public HttpRootPathBuildItem(String rootPath) {
        this.rootPath = UriNormalizationUtil.toURI((String)rootPath, (boolean)true);
    }

    public String getRootPath() {
        return this.rootPath.getPath();
    }

    public String resolvePath(String path) {
        return UriNormalizationUtil.normalizeWithBase((URI)this.rootPath, (String)path, (boolean)false).getPath();
    }

    public String relativePath(String path) {
        String relativePath = path.startsWith("/") ? path.substring(1) : path;
        return UriNormalizationUtil.normalizeWithBase((URI)this.rootPath, (String)relativePath, (boolean)false).getPath();
    }

    public Builder routeBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RouteBuildItem.Builder {
        private final HttpRootPathBuildItem buildItem;
        private RouteBuildItem.RouteType routeType = RouteBuildItem.RouteType.APPLICATION_ROUTE;
        private RouteBuildItem.RouteType routerType = RouteBuildItem.RouteType.APPLICATION_ROUTE;
        private String path;

        private Builder(HttpRootPathBuildItem buildItem) {
            this.buildItem = buildItem;
        }

        @Override
        public Builder routeFunction(Function<Router, Route> routeFunction) {
            throw new RuntimeException("This method is not supported using this builder. Use #routeFunction(String, Consumer<Route>)");
        }

        @Override
        public Builder orderedRoute(String route, Integer order) {
            BasicRoute basicRoute;
            this.absolutePath = this.buildItem.resolvePath(route);
            if ((route = this.absolutePath).startsWith(this.buildItem.getRootPath())) {
                this.path = "/" + UriNormalizationUtil.relativize((String)this.buildItem.getRootPath(), (String)route);
                this.routerType = RouteBuildItem.RouteType.APPLICATION_ROUTE;
            } else if (route.startsWith("/")) {
                this.path = route;
                this.routerType = RouteBuildItem.RouteType.ABSOLUTE_ROUTE;
            }
            this.routeFunction = basicRoute = new BasicRoute(this.path, order);
            return this;
        }

        @Override
        public Builder routeFunction(String route, Consumer<Route> routeFunction) {
            this.absolutePath = this.buildItem.resolvePath(route);
            if ((route = this.absolutePath).startsWith(this.buildItem.getRootPath())) {
                this.path = "/" + UriNormalizationUtil.relativize((String)this.buildItem.getRootPath(), (String)route);
                this.routerType = RouteBuildItem.RouteType.APPLICATION_ROUTE;
            } else if (route.startsWith("/")) {
                this.path = route;
                this.routerType = RouteBuildItem.RouteType.ABSOLUTE_ROUTE;
            }
            super.routeFunction(this.path, routeFunction);
            return this;
        }

        @Override
        public Builder route(String route) {
            this.routeFunction(route, (Consumer)null);
            return this;
        }

        public Builder nestedRoute(String baseRoute, String subRoute) {
            if (subRoute.startsWith("/")) {
                this.routeFunction(subRoute, (Consumer)null);
                return this;
            }
            baseRoute = ((String)baseRoute).endsWith("/") ? baseRoute : (String)baseRoute + "/";
            this.routeFunction((String)baseRoute + subRoute, (Consumer)null);
            return this;
        }

        @Override
        public Builder handler(Handler<RoutingContext> handler) {
            super.handler(handler);
            return this;
        }

        @Override
        public Builder handlerType(HandlerType handlerType) {
            super.handlerType(handlerType);
            return this;
        }

        @Override
        public Builder blockingRoute() {
            super.blockingRoute();
            return this;
        }

        @Override
        public Builder failureRoute() {
            super.failureRoute();
            return this;
        }

        @Override
        public Builder displayOnNotFoundPage() {
            super.displayOnNotFoundPage();
            return this;
        }

        @Override
        public Builder displayOnNotFoundPage(String notFoundPageTitle) {
            super.displayOnNotFoundPage(notFoundPageTitle);
            return this;
        }

        @Override
        public Builder routeConfigKey(String attributeName) {
            super.routeConfigKey(attributeName);
            return this;
        }

        @Override
        public RouteBuildItem build() {
            return new RouteBuildItem(this, this.routeType, this.routerType, this.isManagement);
        }

        @Override
        protected ConfiguredPathInfo getRouteConfigInfo() {
            return super.getRouteConfigInfo();
        }

        @Override
        public Builder management() {
            super.management();
            return this;
        }

        @Override
        protected NotFoundPageDisplayableEndpointBuildItem getNotFoundEndpoint() {
            return super.getNotFoundEndpoint();
        }
    }
}

