/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.menu;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devtools.commands.AddExtensions;
import io.quarkus.devtools.commands.ListCategories;
import io.quarkus.devtools.commands.ListExtensions;
import io.quarkus.devtools.commands.RemoveExtensions;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devui.deployment.ExtensionsBuildItem;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.deployment.extension.ExtensionGroup;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.registry.catalog.Extension;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class ExtensionsProcessor {
    private static final String NAMESPACE = "devui-extensions";

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    InternalPageBuildItem createExtensionsPages(ExtensionsBuildItem extensionsBuildItem) {
        InternalPageBuildItem extensionsPages = new InternalPageBuildItem("Extensions", 10);
        Map<ExtensionGroup, List<io.quarkus.devui.deployment.extension.Extension>> response = Map.of(ExtensionGroup.active, extensionsBuildItem.getActiveExtensions(), ExtensionGroup.inactive, extensionsBuildItem.getInactiveExtensions());
        extensionsPages.addBuildTimeData("extensions", response);
        extensionsPages.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace(NAMESPACE)).title("Extensions")).icon("font-awesome-solid:puzzle-piece")).componentLink("qwc-extensions.js"));
        return extensionsPages;
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void createBuildTimeActions(BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer, LaunchModeBuildItem launchModeBuildItem) {
        if (launchModeBuildItem.getDevModeType().isPresent() && ((DevModeType)launchModeBuildItem.getDevModeType().get()).equals((Object)DevModeType.LOCAL)) {
            BuildTimeActionBuildItem buildTimeActions = new BuildTimeActionBuildItem(NAMESPACE);
            this.getCategories(buildTimeActions);
            this.getInstallableExtensions(buildTimeActions);
            this.getInstalledNamespaces(buildTimeActions);
            this.removeExtension(buildTimeActions);
            this.addExtension(buildTimeActions);
            buildTimeActionProducer.produce((BuildItem)buildTimeActions);
        }
    }

    private void getCategories(BuildTimeActionBuildItem buildTimeActions) {
        buildTimeActions.addAction(new Object(){}.getClass().getEnclosingMethod().getName(), ignored -> CompletableFuture.supplyAsync(() -> {
            try {
                QuarkusCommandOutcome outcome = new ListCategories(this.getQuarkusProject()).format("object").execute();
                if (outcome.isSuccess()) {
                    return outcome.getResult();
                }
            }
            catch (QuarkusCommandException ex) {
                throw new RuntimeException(ex);
            }
            return null;
        }));
    }

    private void getInstallableExtensions(BuildTimeActionBuildItem buildTimeActions) {
        buildTimeActions.addAction(new Object(){}.getClass().getEnclosingMethod().getName(), ignored -> CompletableFuture.supplyAsync(() -> {
            try {
                QuarkusCommandOutcome outcome = new ListExtensions(this.getQuarkusProject()).installed(false).all(false).format("object").execute();
                if (outcome.isSuccess()) {
                    return outcome.getResult();
                }
                return null;
            }
            catch (QuarkusCommandException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private void getInstalledNamespaces(BuildTimeActionBuildItem buildTimeActions) {
        buildTimeActions.addAction(new Object(){}.getClass().getEnclosingMethod().getName(), ignored -> CompletableFuture.supplyAsync(() -> {
            try {
                QuarkusCommandOutcome outcome = new ListExtensions(this.getQuarkusProject()).installed(true).all(false).format("object").execute();
                if (outcome.isSuccess()) {
                    List extensionList = (List)outcome.getResult();
                    ArrayList<CallSite> namespaceList = new ArrayList<CallSite>();
                    if (!extensionList.isEmpty()) {
                        for (Extension e : extensionList) {
                            String groupId = e.getArtifact().getGroupId();
                            String artifactId = e.getArtifact().getArtifactId();
                            namespaceList.add((CallSite)((Object)(groupId + "." + artifactId)));
                        }
                    }
                    return namespaceList;
                }
                return null;
            }
            catch (IllegalStateException e) {
                return null;
            }
            catch (QuarkusCommandException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private void removeExtension(BuildTimeActionBuildItem buildTimeActions) {
        buildTimeActions.addAction(new Object(){}.getClass().getEnclosingMethod().getName(), params -> CompletableFuture.supplyAsync(() -> {
            String extensionArtifactId = (String)params.get("extensionArtifactId");
            try {
                QuarkusCommandOutcome outcome = new RemoveExtensions(this.getQuarkusProject()).extensions(Set.of(extensionArtifactId)).execute();
                if (outcome.isSuccess()) {
                    return true;
                }
                return false;
            }
            catch (QuarkusCommandException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private void addExtension(BuildTimeActionBuildItem buildTimeActions) {
        buildTimeActions.addAction(new Object(){}.getClass().getEnclosingMethod().getName(), params -> CompletableFuture.supplyAsync(() -> {
            String extensionArtifactId = (String)params.get("extensionArtifactId");
            try {
                QuarkusCommandOutcome outcome = new AddExtensions(this.getQuarkusProject()).extensions(Set.of(extensionArtifactId)).execute();
                if (outcome.isSuccess()) {
                    return true;
                }
                return false;
            }
            catch (QuarkusCommandException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private QuarkusProject getQuarkusProject() {
        String gradlePath = System.getProperty("gradle.project.path");
        Path projectRoot = gradlePath != null ? Path.of(gradlePath, new String[0]) : Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize();
        return QuarkusProjectHelper.getCachedProject((Path)projectRoot);
    }
}

