/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.testing.ContinuousTestingSharedStateManager;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.devmode.ContinuousTestWebSocketHandler;
import io.quarkus.vertx.http.runtime.devmode.FileSystemStaticHandler;
import io.smallrye.config.SmallRyeConfig;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;

@Recorder
public class DevConsoleRecorder {
    public void addInfo(String groupId, String artifactId, String name, Supplier<? extends Object> supplier) {
        Map info = DevConsoleManager.getTemplateInfo();
        Map<String, Object> data = info.computeIfAbsent(groupId + "." + artifactId, new Function<String, Map<String, Object>>(){

            @Override
            public Map<String, Object> apply(String s) {
                return new HashMap<String, Object>();
            }
        });
        data.put(name, supplier.get());
    }

    public void initConfigFun() {
        final SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
        DevConsoleManager.setGlobal((String)"devui-config-fun", (Object)new Function<String, Optional<String>>(){

            @Override
            public Optional<String> apply(String name) {
                return config.getOptionalValue(name, String.class);
            }
        });
    }

    @Deprecated
    public Handler<RoutingContext> devConsoleHandler(String devConsoleFinalDestination, ShutdownContext shutdownContext) {
        ArrayList<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations = new ArrayList<FileSystemStaticHandler.StaticWebRootConfiguration>();
        webRootConfigurations.add(new FileSystemStaticHandler.StaticWebRootConfiguration(devConsoleFinalDestination, ""));
        return this.fileSystemStaticHandler(webRootConfigurations, shutdownContext);
    }

    public Handler<RoutingContext> fileSystemStaticHandler(List<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations, ShutdownContext shutdownContext) {
        FileSystemStaticHandler fileSystemStaticHandler = new FileSystemStaticHandler(webRootConfigurations);
        shutdownContext.addShutdownTask((Runnable)new ShutdownContext.CloseRunnable((Closeable)fileSystemStaticHandler));
        return fileSystemStaticHandler;
    }

    public Handler<RoutingContext> continuousTestHandler(ShutdownContext context) {
        final ContinuousTestWebSocketHandler handler = new ContinuousTestWebSocketHandler();
        ContinuousTestingSharedStateManager.addStateListener((Consumer)handler);
        context.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                ContinuousTestingSharedStateManager.removeStateListener((Consumer)handler);
            }
        });
        return handler;
    }
}

