/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.webjar.locator.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;

@Recorder
public class WebJarLocatorRecorder {
    public Handler<RoutingContext> getHandler(String webjarsRootUrl, Map<String, String> webjarNameToVersionMap) {
        return event -> {
            String path = event.normalizedPath();
            if (path.startsWith(webjarsRootUrl)) {
                String rest = path.substring(webjarsRootUrl.length());
                String webjar = rest.substring(0, rest.indexOf(47));
                if (webjarNameToVersionMap.containsKey(webjar)) {
                    int endOfVersion = rest.indexOf(47, rest.indexOf(47) + 1);
                    if (endOfVersion == -1) {
                        endOfVersion = rest.length();
                    }
                    String nextPathEntry = rest.substring(rest.indexOf(47) + 1, endOfVersion);
                    if (webjarNameToVersionMap.get(webjar) == null || nextPathEntry.equals(webjarNameToVersionMap.get(webjar))) {
                        event.next();
                    } else {
                        event.reroute(webjarsRootUrl + webjar + "/" + (String)webjarNameToVersionMap.get(webjar) + rest.substring(rest.indexOf(47)));
                    }
                } else {
                    event.fail(404);
                }
            } else {
                event.next();
            }
        };
    }
}

