/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.semconv.UrlAttributes;
import io.quarkus.websockets.next.WebSocketClientConnection;
import io.quarkus.websockets.next.WebSocketConnection;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.telemetry.ForwardingWebSocketEndpoint;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.function.Function;

final class TracesForwardingWebSocketEndpoint
extends ForwardingWebSocketEndpoint {
    private final String targetIdKey;
    private final String targetIdValue;
    private final Tracer tracer;
    private final String connectionId;
    private final String path;
    private final SpanContext onOpenSpanContext;
    private final SpanKind spanKind;

    TracesForwardingWebSocketEndpoint(WebSocketEndpoint delegate, Tracer tracer, WebSocketConnection connection, SpanContext onOpenSpanContext, String path) {
        this(delegate, tracer, onOpenSpanContext, path, "connection.endpoint.id", SpanKind.SERVER, connection.endpointId(), connection.id());
    }

    TracesForwardingWebSocketEndpoint(WebSocketEndpoint delegate, Tracer tracer, WebSocketClientConnection connection, SpanContext onOpenSpanContext, String path) {
        this(delegate, tracer, onOpenSpanContext, path, "connection.client.id", SpanKind.CLIENT, connection.clientId(), connection.id());
    }

    private TracesForwardingWebSocketEndpoint(WebSocketEndpoint delegate, Tracer tracer, SpanContext onOpenSpanContext, String path, String targetIdKey, SpanKind spanKind, String targetIdValue, String connectionId) {
        super(delegate);
        this.tracer = tracer;
        this.onOpenSpanContext = onOpenSpanContext;
        this.connectionId = connectionId;
        this.targetIdKey = targetIdKey;
        this.targetIdValue = targetIdValue;
        this.path = path;
        this.spanKind = spanKind;
    }

    @Override
    public Future<Void> onClose() {
        return this.delegate.onClose().map((Function)new Function<Void, Void>(){

            @Override
            public Void apply(Void unused) {
                TracesForwardingWebSocketEndpoint.this.tracer.spanBuilder("CLOSE " + TracesForwardingWebSocketEndpoint.this.path).setSpanKind(TracesForwardingWebSocketEndpoint.this.spanKind).addLink(TracesForwardingWebSocketEndpoint.this.onOpenSpanContext).setAttribute("connection.id", TracesForwardingWebSocketEndpoint.this.connectionId).setAttribute(UrlAttributes.URL_PATH, (Object)TracesForwardingWebSocketEndpoint.this.path).setAttribute(TracesForwardingWebSocketEndpoint.this.targetIdKey, TracesForwardingWebSocketEndpoint.this.targetIdValue).startSpan().end();
                return null;
            }
        }).onFailure((Handler)new Handler<Throwable>(){

            public void handle(Throwable throwable) {
                TracesForwardingWebSocketEndpoint.this.tracer.spanBuilder("CLOSE " + TracesForwardingWebSocketEndpoint.this.path).setSpanKind(TracesForwardingWebSocketEndpoint.this.spanKind).addLink(TracesForwardingWebSocketEndpoint.this.onOpenSpanContext).setAttribute("connection.id", TracesForwardingWebSocketEndpoint.this.connectionId).setAttribute(UrlAttributes.URL_PATH, (Object)TracesForwardingWebSocketEndpoint.this.path).setAttribute(TracesForwardingWebSocketEndpoint.this.targetIdKey, TracesForwardingWebSocketEndpoint.this.targetIdValue).startSpan().recordException(throwable).end();
            }
        });
    }
}

