/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.runtime.Shutdown;
import io.quarkus.websockets.next.Closed;
import io.quarkus.websockets.next.Connection;
import io.quarkus.websockets.next.Open;
import io.quarkus.websockets.next.OpenClientConnections;
import io.quarkus.websockets.next.WebSocketClientConnection;
import io.quarkus.websockets.next.runtime.WebSocketClientConnectionImpl;
import jakarta.enterprise.event.Event;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

@Singleton
public class ClientConnectionManager
implements OpenClientConnections {
    private static final Logger LOG = Logger.getLogger(ClientConnectionManager.class);
    private final ConcurrentMap<String, Set<WebSocketClientConnectionImpl>> endpointToConnections = new ConcurrentHashMap<String, Set<WebSocketClientConnectionImpl>>();
    private final List<ClientConnectionListener> listeners = new CopyOnWriteArrayList<ClientConnectionListener>();
    private final Event<WebSocketClientConnection> openEvent;
    private final Event<WebSocketClientConnection> closedEvent;

    ClientConnectionManager(@Open Event<WebSocketClientConnection> openEvent, @Closed Event<WebSocketClientConnection> closedEvent) {
        ArcContainer container = Arc.container();
        this.openEvent = container.resolveObserverMethods(WebSocketClientConnection.class, new Annotation[]{Open.Literal.INSTANCE}).isEmpty() ? null : openEvent;
        this.closedEvent = container.resolveObserverMethods(WebSocketClientConnection.class, new Annotation[]{Closed.Literal.INSTANCE}).isEmpty() ? null : closedEvent;
    }

    @Override
    public Iterator<WebSocketClientConnection> iterator() {
        return this.stream().iterator();
    }

    @Override
    public Stream<WebSocketClientConnection> stream() {
        return this.endpointToConnections.values().stream().flatMap(Collection::stream).filter(Connection::isOpen).map(WebSocketClientConnection.class::cast);
    }

    void add(String endpoint, WebSocketClientConnectionImpl connection) {
        LOG.debugf("Add client connection: %s", (Object)connection);
        if (this.endpointToConnections.computeIfAbsent(endpoint, e -> ConcurrentHashMap.newKeySet()).add(connection)) {
            if (this.openEvent != null) {
                this.openEvent.fireAsync((Object)connection);
            }
            if (!this.listeners.isEmpty()) {
                for (ClientConnectionListener listener : this.listeners) {
                    try {
                        listener.connectionAdded(endpoint, connection);
                    }
                    catch (Exception e2) {
                        LOG.warnf("Unable to call listener#connectionAdded() on [%s]: %s", listener.getClass(), (Object)e2.toString());
                    }
                }
            }
        }
    }

    void remove(String endpoint, WebSocketClientConnectionImpl connection) {
        LOG.debugf("Remove client connection: %s", (Object)connection);
        Set connections = (Set)this.endpointToConnections.get(endpoint);
        if (connections != null && connections.remove(connection)) {
            if (this.closedEvent != null) {
                this.closedEvent.fireAsync((Object)connection);
            }
            if (!this.listeners.isEmpty()) {
                for (ClientConnectionListener listener : this.listeners) {
                    try {
                        listener.connectionRemoved(endpoint, connection.id());
                    }
                    catch (Exception e) {
                        LOG.warnf("Unable to call listener#connectionRemoved() on [%s]: %s", listener.getClass(), (Object)e.toString());
                    }
                }
            }
        }
    }

    public Set<WebSocketClientConnectionImpl> getConnections(String endpoint) {
        Set ret = (Set)this.endpointToConnections.get(endpoint);
        if (ret == null) {
            return Set.of();
        }
        return ret;
    }

    public void addListener(ClientConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Shutdown
    void cleanup() {
        if (!this.endpointToConnections.isEmpty()) {
            int sum = 0;
            for (Map.Entry e : this.endpointToConnections.entrySet()) {
                for (WebSocketClientConnectionImpl c : (Set)e.getValue()) {
                    c.cleanup();
                    ++sum;
                }
            }
            LOG.debugf("Cleanup performed for %s connections", sum);
            this.endpointToConnections.clear();
        }
    }

    public static interface ClientConnectionListener {
        public void connectionAdded(String var1, WebSocketClientConnection var2);

        public void connectionRemoved(String var1, String var2);
    }
}

