/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.telemetry.ConnectionInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.ErrorInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.SendingInterceptor;
import java.util.Map;

public abstract class TelemetrySupport {
    private final ConnectionInterceptor connectionInterceptor;
    private final SendingInterceptor sendingInterceptor;
    private final ErrorInterceptor errorInterceptor;

    TelemetrySupport(ConnectionInterceptor connectionInterceptor, SendingInterceptor sendingInterceptor, ErrorInterceptor errorInterceptor) {
        this.connectionInterceptor = connectionInterceptor;
        this.sendingInterceptor = sendingInterceptor;
        this.errorInterceptor = errorInterceptor;
    }

    public abstract WebSocketEndpoint decorate(WebSocketEndpoint var1, WebSocketConnectionBase var2);

    public boolean interceptConnection() {
        return this.connectionInterceptor != null;
    }

    public void connectionOpened() {
        this.connectionInterceptor.connectionOpened();
    }

    public void connectionOpeningFailed(Throwable throwable) {
        this.connectionInterceptor.connectionOpeningFailed(throwable);
    }

    public SendingInterceptor getSendingInterceptor() {
        return this.sendingInterceptor;
    }

    public ErrorInterceptor getErrorInterceptor() {
        return this.errorInterceptor;
    }

    protected Map<String, Object> getContextData() {
        return this.connectionInterceptor == null ? Map.of() : this.connectionInterceptor.getContextData();
    }
}

