/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.generator;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.Switch;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.TemplateGlobal;
import io.quarkus.qute.TemplateGlobalProvider;
import io.quarkus.qute.generator.AbstractGenerator;
import io.quarkus.qute.generator.Descriptors;
import io.quarkus.qute.generator.ValueResolverGenerator;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class TemplateGlobalGenerator
extends AbstractGenerator {
    public static final DotName TEMPLATE_GLOBAL = DotName.createSimple((String)TemplateGlobal.class.getName());
    public static final String NAME = "name";
    public static final String SUFFIX = "_Globals";
    private final String namespace;
    private int priority;

    public TemplateGlobalGenerator(ClassOutput classOutput, String namespace, int initialPriority, IndexView index) {
        super(index, classOutput);
        this.namespace = namespace;
        this.priority = initialPriority;
    }

    public String generate(ClassInfo declaringClass, Map<String, AnnotationTarget> targets) {
        Object baseName = declaringClass.enclosingClass() != null ? ValueResolverGenerator.simpleName(declaringClass.enclosingClass()) + "$_" + ValueResolverGenerator.simpleName(declaringClass) : ValueResolverGenerator.simpleName(declaringClass);
        String targetPackage = ValueResolverGenerator.packageName(declaringClass.name());
        String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, (String)baseName, SUFFIX);
        String generatedClassName = generatedName.replace('/', '.');
        this.generatedTypes.add(generatedClassName);
        final ClassCreator provider = ClassCreator.builder().classOutput(this.classOutput).className(generatedName).interfaces(new Class[]{TemplateGlobalProvider.class}).build();
        MethodCreator accept = (MethodCreator)provider.getMethodCreator("accept", Void.TYPE, new Class[]{Object.class}).setModifiers(1);
        for (Map.Entry<String, AnnotationTarget> entry : targets.entrySet()) {
            ResultHandle name = accept.load(entry.getKey());
            FunctionCreator fun = accept.createFunction(Function.class);
            BytecodeCreator funBytecode = fun.getBytecode();
            funBytecode.returnValue(switch (entry.getValue().kind()) {
                case AnnotationTarget.Kind.FIELD -> {
                    FieldInfo field = entry.getValue().asField();
                    TemplateGlobalGenerator.validate(field);
                    yield funBytecode.readStaticField(FieldDescriptor.of((FieldInfo)field));
                }
                case AnnotationTarget.Kind.METHOD -> {
                    MethodInfo method = entry.getValue().asMethod();
                    TemplateGlobalGenerator.validate(method);
                    yield funBytecode.invokeStaticMethod(MethodDescriptor.of((MethodInfo)method), new ResultHandle[0]);
                }
                default -> throw new IllegalStateException("Unsupported target: " + String.valueOf(entry.getValue()));
            });
            accept.invokeInterfaceMethod(Descriptors.TEMPLATE_INSTANCE_COMPUTED_DATA, accept.getMethodParam(0), new ResultHandle[]{name, fun.getInstance()});
        }
        accept.returnValue(null);
        MethodCreator getNamespace = provider.getMethodCreator("getNamespace", String.class, new Class[0]);
        getNamespace.returnValue(getNamespace.load(this.namespace));
        MethodCreator getPriority = provider.getMethodCreator("getPriority", Integer.TYPE, new Class[0]);
        getPriority.returnValue(getPriority.load(this.priority++));
        MethodCreator resolve = (MethodCreator)provider.getMethodCreator("resolve", CompletionStage.class, new Class[]{EvalContext.class}).setModifiers(1);
        ResultHandle evalContext = resolve.getMethodParam(0);
        ResultHandle name = resolve.invokeInterfaceMethod(Descriptors.GET_NAME, evalContext, new ResultHandle[0]);
        Switch.StringSwitch nameSwitch = resolve.stringSwitch(name);
        for (final Map.Entry<String, AnnotationTarget> e : targets.entrySet()) {
            Consumer<BytecodeCreator> readGlobal = new Consumer<BytecodeCreator>(){

                @Override
                public void accept(BytecodeCreator bc) {
                    switch (((AnnotationTarget)e.getValue()).kind()) {
                        case FIELD: {
                            FieldInfo field = ((AnnotationTarget)e.getValue()).asField();
                            TemplateGlobalGenerator.this.processReturnVal(bc, field.type(), bc.readStaticField(FieldDescriptor.of((FieldInfo)field)), provider);
                            break;
                        }
                        case METHOD: {
                            MethodInfo method = ((AnnotationTarget)e.getValue()).asMethod();
                            TemplateGlobalGenerator.this.processReturnVal(bc, method.returnType(), bc.invokeStaticMethod(MethodDescriptor.of((MethodInfo)method), new ResultHandle[0]), provider);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported target: " + String.valueOf(e.getValue()));
                        }
                    }
                }
            };
            nameSwitch.caseOf((Object)e.getKey(), (Consumer)readGlobal);
        }
        resolve.returnValue(resolve.invokeStaticMethod(Descriptors.RESULTS_NOT_FOUND_EC, new ResultHandle[]{evalContext}));
        provider.close();
        return generatedClassName;
    }

    @Override
    public Set<String> getGeneratedTypes() {
        return this.generatedTypes;
    }

    public static void validate(MethodInfo method) {
        if (!Modifier.isStatic(method.flags())) {
            throw new IllegalStateException("Global variable method declared on " + String.valueOf(method.declaringClass().name()) + " must be static: " + String.valueOf(method));
        }
        if (method.returnType().kind() == Type.Kind.VOID) {
            throw new IllegalStateException("Global variable method declared on " + String.valueOf(method.declaringClass().name()) + " must not return void: " + String.valueOf(method));
        }
        if (!method.parameterTypes().isEmpty()) {
            throw new IllegalStateException("Global variable method declared on " + String.valueOf(method.declaringClass().name()) + " must not accept any parameter: " + String.valueOf(method));
        }
        if (Modifier.isPrivate(method.flags())) {
            throw new IllegalStateException("Global variable method declared on " + String.valueOf(method.declaringClass().name()) + " must not be private: " + String.valueOf(method));
        }
    }

    public static void validate(FieldInfo field) {
        if (!Modifier.isStatic(field.flags())) {
            throw new IllegalStateException("Global variable field declared on " + String.valueOf(field.declaringClass().name()) + "  must be static: " + String.valueOf(field));
        }
        if (Modifier.isPrivate(field.flags())) {
            throw new IllegalStateException("Global variable field declared on " + String.valueOf(field.declaringClass().name()) + " must not be private: " + String.valueOf(field));
        }
    }
}

