/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.generator;

import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.IfThenElse;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.generator.Descriptors;
import io.quarkus.qute.generator.DotNames;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;

public abstract class AbstractGenerator {
    protected final Set<String> generatedTypes = new HashSet<String>();
    protected final IndexView index;
    protected final ClassOutput classOutput;

    protected AbstractGenerator(IndexView index, ClassOutput classOutput) {
        this.index = index;
        this.classOutput = classOutput;
    }

    public Set<String> getGeneratedTypes() {
        return this.generatedTypes;
    }

    protected void completeBoolean(BytecodeCreator bc, ResultHandle result) {
        BranchResult isTrue = bc.ifTrue(result);
        BytecodeCreator trueBranch = isTrue.trueBranch();
        trueBranch.returnValue(trueBranch.readStaticField(Descriptors.RESULTS_TRUE));
        BytecodeCreator falseBranch = isTrue.falseBranch();
        falseBranch.returnValue(falseBranch.readStaticField(Descriptors.RESULTS_FALSE));
    }

    protected boolean isEnum(Type returnType) {
        if (returnType.kind() != Type.Kind.CLASS) {
            return false;
        }
        ClassInfo maybeEnum = this.index.getClassByName(returnType.name());
        return maybeEnum != null && maybeEnum.isEnum();
    }

    protected boolean hasCompletionStage(Type type) {
        return !this.skipMemberType(type) && this.hasCompletionStageInTypeClosure(this.index.getClassByName(type.name()), this.index);
    }

    protected boolean hasCompletionStageInTypeClosure(ClassInfo classInfo, IndexView index) {
        return this.hasClassInTypeClosure(classInfo, DotNames.COMPLETION_STAGE, index);
    }

    protected boolean hasClassInTypeClosure(ClassInfo classInfo, DotName className, IndexView index) {
        ClassInfo superClassInfo;
        if (classInfo == null) {
            return false;
        }
        if (classInfo.name().equals((Object)className)) {
            return true;
        }
        for (Type interfaceType : classInfo.interfaceTypes()) {
            ClassInfo interfaceClassInfo = index.getClassByName(interfaceType.name());
            if (interfaceClassInfo == null || !this.hasCompletionStageInTypeClosure(interfaceClassInfo, index)) continue;
            return true;
        }
        return classInfo.superClassType() != null && (superClassInfo = index.getClassByName(classInfo.superName())) != null && this.hasClassInTypeClosure(superClassInfo, className, index);
    }

    protected void processReturnVal(BytecodeCreator bc, Type type, ResultHandle ret, ClassCreator classCreator) {
        if (this.hasCompletionStage(type)) {
            bc.returnValue(ret);
        } else if (type.kind() == Type.Kind.PRIMITIVE && type.asPrimitiveType().primitive() == PrimitiveType.Primitive.BOOLEAN) {
            this.completeBoolean(bc, ret);
        } else if (type.name().equals((Object)DotNames.BOOLEAN)) {
            BytecodeCreator isNull = bc.ifNull(ret).trueBranch();
            isNull.returnValue(isNull.readStaticField(Descriptors.RESULTS_NULL));
            this.completeBoolean(bc, bc.invokeVirtualMethod(Descriptors.BOOLEAN_VALUE, ret, new ResultHandle[0]));
        } else if (this.isEnum(type)) {
            BytecodeCreator isNull = bc.ifNull(ret).trueBranch();
            isNull.returnValue(isNull.readStaticField(Descriptors.RESULTS_NULL));
            this.completeEnum(this.index.getClassByName(type.name()), classCreator, ret, bc);
        } else {
            bc.returnValue(bc.invokeStaticMethod(Descriptors.COMPLETED_STAGE_OF, new ResultHandle[]{ret}));
        }
    }

    protected boolean completeEnum(ClassInfo enumClass, ClassCreator valueResolver, ResultHandle result, BytecodeCreator bc) {
        IfThenElse ifThenElse = null;
        for (FieldInfo enumConstant : enumClass.enumConstants()) {
            BytecodeCreator match;
            String name = enumClass.name().toString().replace(".", "_") + "$$" + enumConstant.name();
            FieldDescriptor enumConstantField = FieldDescriptor.of((String)enumClass.name().toString(), (String)enumConstant.name(), (String)enumClass.name().toString());
            FieldDescriptor csField = ((FieldCreator)valueResolver.getFieldCreator(name, CompletedStage.class).setModifiers(2)).getFieldDescriptor();
            MethodCreator enumConstantMethod = (MethodCreator)valueResolver.getMethodCreator(name, CompletedStage.class, new Class[0]).setModifiers(2);
            BytecodeCreator isNull = enumConstantMethod.ifNull(enumConstantMethod.readInstanceField(csField, enumConstantMethod.getThis())).trueBranch();
            ResultHandle val = isNull.readStaticField(enumConstantField);
            isNull.writeInstanceField(csField, enumConstantMethod.getThis(), isNull.invokeStaticMethod(Descriptors.COMPLETED_STAGE_OF, new ResultHandle[]{val}));
            enumConstantMethod.returnValue(enumConstantMethod.readInstanceField(csField, enumConstantMethod.getThis()));
            if (ifThenElse == null) {
                ifThenElse = bc.ifThenElse(Gizmo.equals((BytecodeCreator)bc, (ResultHandle)bc.readStaticField(enumConstantField), (ResultHandle)result));
                match = ifThenElse.then();
            } else {
                match = ifThenElse.elseIf(b -> Gizmo.equals((BytecodeCreator)b, (ResultHandle)b.readStaticField(enumConstantField), (ResultHandle)result));
            }
            match.returnValue(match.invokeVirtualMethod(enumConstantMethod.getMethodDescriptor(), match.getThis(), new ResultHandle[0]));
        }
        return true;
    }

    protected boolean skipMemberType(Type type) {
        switch (type.kind()) {
            case VOID: 
            case PRIMITIVE: 
            case ARRAY: 
            case TYPE_VARIABLE: 
            case UNRESOLVED_TYPE_VARIABLE: 
            case TYPE_VARIABLE_REFERENCE: 
            case WILDCARD_TYPE: {
                return true;
            }
        }
        return false;
    }
}

