/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor;

import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.sse.SseEventSink;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.WildcardType;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.model.InjectableBean;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.AsmUtil;
import org.jboss.resteasy.reactive.common.processor.BlockingDefault;
import org.jboss.resteasy.reactive.common.processor.IndexedParameter;
import org.jboss.resteasy.reactive.common.processor.JandexUtil;
import org.jboss.resteasy.reactive.common.processor.NameBindingUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.StringUtil;
import org.jboss.resteasy.reactive.common.processor.TargetJavaVersion;
import org.jboss.resteasy.reactive.common.processor.TypeArgMapper;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationStore;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformer;
import org.jboss.resteasy.reactive.common.util.URLUtils;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public abstract class EndpointIndexer<T extends EndpointIndexer<T, PARAM, METHOD>, PARAM extends IndexedParameter<PARAM>, METHOD extends ResourceMethod> {
    public static final Map<String, String> primitiveTypes;
    private static final Map<DotName, Class<?>> supportedReaderJavaTypes;
    private static final Set<DotName> DEFAULT_CONTEXT_TYPES;
    protected static final Set<DotName> SUPPORT_TEMPORAL_PARAMS;
    protected static final Logger log;
    protected static final String[] EMPTY_STRING_ARRAY;
    private static final String[] PRODUCES_PLAIN_TEXT_NEGOTIATED;
    private static final String[] PRODUCES_PLAIN_TEXT;
    public static final String CDI_WRAPPER_SUFFIX = "$$CDIWrapper";
    public static final String METHOD_CONTEXT_CUSTOM_RETURN_TYPE_KEY = "METHOD_CONTEXT_CUSTOM_RETURN_TYPE_KEY";
    public static final String METHOD_CONTEXT_ANNOTATION_STORE = "ANNOTATION_STORE";
    public static final String METHOD_PRODUCES = "METHOD_PRODUCES";
    private static final boolean JDK_SUPPORTS_VIRTUAL_THREADS;
    protected final IndexView index;
    protected final IndexView applicationIndex;
    protected final Map<String, String> existingConverters;
    protected final Map<String, InjectableBean> injectableBeans;
    protected final boolean hasRuntimeConverters;
    private final Map<DotName, String> scannedResourcePaths;
    protected final ResteasyReactiveConfig config;
    protected final AdditionalReaders additionalReaders;
    private final Map<DotName, String> httpAnnotationToMethod;
    private final AdditionalWriters additionalWriters;
    private final BlockingDefault defaultBlocking;
    private final Map<DotName, Map<String, String>> classLevelExceptionMappers;
    private final Function<String, BeanFactory<Object>> factoryCreator;
    private final Consumer<ResourceMethodCallbackEntry> resourceMethodCallback;
    private final AnnotationStore annotationStore;
    protected final ApplicationScanningResult applicationScanningResult;
    private final Set<DotName> contextTypes;
    private final Set<DotName> parameterContainerTypes;
    private final MultipartReturnTypeIndexerExtension multipartReturnTypeIndexerExtension;
    private final TargetJavaVersion targetJavaVersion;
    private final Function<ClassInfo, Supplier<Boolean>> isDisabledCreator;
    private final Predicate<Map<DotName, AnnotationInstance>> skipMethodParameter;

    protected EndpointIndexer(Builder<T, ?, METHOD> builder) {
        this.index = builder.index;
        this.applicationIndex = builder.applicationIndex;
        this.existingConverters = builder.existingConverters;
        this.scannedResourcePaths = builder.scannedResourcePaths;
        this.config = builder.config;
        this.additionalReaders = builder.additionalReaders;
        this.httpAnnotationToMethod = builder.httpAnnotationToMethod;
        this.injectableBeans = builder.injectableBeans;
        this.additionalWriters = builder.additionalWriters;
        this.hasRuntimeConverters = builder.hasRuntimeConverters;
        this.defaultBlocking = builder.defaultBlocking;
        this.classLevelExceptionMappers = builder.classLevelExceptionMappers;
        this.factoryCreator = builder.factoryCreator;
        this.resourceMethodCallback = builder.resourceMethodCallback;
        this.annotationStore = new AnnotationStore(builder.annotationsTransformers);
        this.applicationScanningResult = builder.applicationScanningResult;
        this.contextTypes = builder.contextTypes;
        this.parameterContainerTypes = builder.parameterContainerTypes;
        this.multipartReturnTypeIndexerExtension = builder.multipartReturnTypeIndexerExtension;
        this.targetJavaVersion = builder.targetJavaVersion;
        this.isDisabledCreator = builder.isDisabledCreator;
        this.skipMethodParameter = builder.skipMethodParameter;
    }

    public Optional<ResourceClass> createEndpoints(ClassInfo classInfo, boolean considerApplication) {
        if (considerApplication && !this.applicationScanningResult.keepClass(classInfo.name().toString())) {
            return Optional.empty();
        }
        try {
            Map<String, String> classLevelExceptionMappers;
            Object path = this.scannedResourcePaths.get(classInfo.name());
            ResourceClass clazz = new ResourceClass();
            if (classInfo.enclosingClass() != null && !Modifier.isStatic(classInfo.flags())) {
                throw new DeploymentException("Non static nested resources classes are not supported: '" + classInfo.name() + "'");
            }
            clazz.setClassName(classInfo.name().toString());
            if (path != null) {
                if (((String)path).endsWith("/")) {
                    path = ((String)path).substring(0, ((String)path).length() - 1);
                }
                if (!((String)path).startsWith("/")) {
                    path = "/" + (String)path;
                }
                clazz.setPath(this.sanitizePath((String)path));
            }
            if (this.factoryCreator != null) {
                clazz.setFactory(this.factoryCreator.apply(classInfo.name().toString()));
            }
            if ((classLevelExceptionMappers = this.classLevelExceptionMappers.get(classInfo.name())) != null) {
                clazz.setClassLevelExceptionMappers(classLevelExceptionMappers);
            }
            List<ResourceMethod> methods = this.createEndpoints(classInfo, classInfo, new HashSet<String>(), new HashSet<String>(), clazz.getPathParameters(), clazz.getPath(), considerApplication);
            clazz.getMethods().addAll(methods);
            InjectableBean injectableBean = this.scanInjectableBean(classInfo, classInfo, this.existingConverters, this.additionalReaders, this.injectableBeans, this.hasRuntimeConverters);
            if (injectableBean.isFormParamRequired()) {
                clazz.setFormParamRequired(true);
                for (ResourceMethod method : methods) {
                    method.setFormParamRequired(true);
                }
            }
            if (injectableBean.isInjectionRequired()) {
                clazz.setPerRequestResource(true);
            }
            if (this.isDisabledCreator != null) {
                clazz.setIsDisabled(this.isDisabledCreator.apply(classInfo));
            }
            return Optional.of(clazz);
        }
        catch (Exception e) {
            if (Modifier.isInterface(classInfo.flags()) || Modifier.isAbstract(classInfo.flags())) {
                log.debug((Object)("Ignoring interface " + classInfo.name()), (Throwable)e);
                return Optional.empty();
            }
            throw new RuntimeException(e);
        }
    }

    private String sanitizePath(String path) {
        int bracesCount = 0;
        StringBuilder replaced = null;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == ' ' && bracesCount == 0) {
                if (replaced == null) {
                    replaced = new StringBuilder(path.length() + 2);
                    replaced.append(path, 0, i);
                }
                replaced.append("%20");
                continue;
            }
            if (replaced != null) {
                replaced.append(c);
            }
            if (c == '{') {
                ++bracesCount;
                continue;
            }
            if (c != '}') continue;
            --bracesCount;
        }
        if (replaced == null) {
            return path;
        }
        return replaced.toString();
    }

    protected abstract METHOD createResourceMethod(MethodInfo var1, ClassInfo var2, Map<String, Object> var3);

    protected List<ResourceMethod> createEndpoints(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, Set<String> seenMethods, Set<String> existingClassNameBindings, Set<String> pathParameters, String resourceClassPath, boolean considerApplication) {
        ArrayList<ResourceMethod> ret = new ArrayList<ResourceMethod>();
        List<FoundEndpoint> endpoints = EndpointIndexer.collectEndpoints(currentClassInfo, actualEndpointInfo, seenMethods, existingClassNameBindings, considerApplication, this.httpAnnotationToMethod, this.index, this.applicationScanningResult, this.getAnnotationStore());
        HashMap<String, BasicResourceClassInfo> basicResourceClassInfoMap = new HashMap<String, BasicResourceClassInfo>();
        for (FoundEndpoint endpoint : endpoints) {
            BasicResourceClassInfo basicResourceClassInfo;
            Object methodPath = EndpointIndexer.readStringValue(this.getAnnotationStore().getAnnotation((AnnotationTarget)endpoint.methodInfo, ResteasyReactiveDotNames.PATH));
            if (endpoint.httpMethod != null) {
                this.validateHttpAnnotations(endpoint.methodInfo);
                if (methodPath != null) {
                    if (!((String)methodPath).startsWith("/")) {
                        methodPath = "/" + (String)methodPath;
                    }
                    if (((String)methodPath).endsWith("/")) {
                        methodPath = this.handleTrailingSlash((String)methodPath);
                    }
                } else {
                    methodPath = "";
                }
            } else if (methodPath != null) {
                if (!((String)methodPath).startsWith("/")) {
                    methodPath = "/" + (String)methodPath;
                }
                if (((String)methodPath).endsWith("/")) {
                    methodPath = ((String)methodPath).substring(0, ((String)methodPath).length() - 1);
                }
            }
            if ((basicResourceClassInfo = (BasicResourceClassInfo)basicResourceClassInfoMap.get(endpoint.classInfo.name().toString())) == null) {
                String[] classProduces = EndpointIndexer.extractProducesConsumesValues(this.getAnnotationStore().getAnnotation((AnnotationTarget)endpoint.classInfo, ResteasyReactiveDotNames.PRODUCES));
                String[] classConsumes = EndpointIndexer.extractProducesConsumesValues(this.getAnnotationStore().getAnnotation((AnnotationTarget)endpoint.classInfo, ResteasyReactiveDotNames.CONSUMES));
                basicResourceClassInfo = new BasicResourceClassInfo(resourceClassPath, classProduces, classConsumes, pathParameters, this.getStreamAnnotationValue((AnnotationTarget)endpoint.classInfo));
                basicResourceClassInfoMap.put(endpoint.classInfo.name().toString(), basicResourceClassInfo);
            }
            ResourceMethod method = this.createResourceMethod(endpoint.classInfo, actualEndpointInfo, basicResourceClassInfo, endpoint.classNameBindings, endpoint.httpMethod, endpoint.methodInfo, (String)methodPath);
            ret.add(method);
        }
        return ret;
    }

    private static List<FoundEndpoint> collectEndpoints(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, Set<String> seenMethods, Set<String> existingClassNameBindings, boolean considerApplication, Map<DotName, String> httpAnnotationToMethod, IndexView index, ApplicationScanningResult applicationScanningResult, AnnotationStore annotationStore) {
        ClassInfo superClass;
        if (considerApplication && applicationScanningResult != null && !applicationScanningResult.keepClass(actualEndpointInfo.name().toString())) {
            return Collections.emptyList();
        }
        if (currentClassInfo.name().toString().endsWith(CDI_WRAPPER_SUFFIX)) {
            return Collections.emptyList();
        }
        ArrayList<FoundEndpoint> ret = new ArrayList<FoundEndpoint>();
        Set<String> classNameBindings = NameBindingUtil.nameBindingNames(index, currentClassInfo);
        if (classNameBindings.isEmpty()) {
            classNameBindings = existingClassNameBindings;
        }
        for (DotName dotName : httpAnnotationToMethod.keySet()) {
            List methods = currentClassInfo.methods();
            for (MethodInfo info : methods) {
                String descriptor;
                AnnotationInstance annotation = annotationStore.getAnnotation((AnnotationTarget)info, dotName);
                if (annotation == null || !EndpointIndexer.hasProperModifiers(info) || seenMethods.contains(descriptor = EndpointIndexer.methodDescriptor(info))) continue;
                seenMethods.add(descriptor);
                ret.add(new FoundEndpoint(currentClassInfo, classNameBindings, info, dotName));
            }
        }
        List methods = currentClassInfo.methods();
        for (MethodInfo info : methods) {
            String descriptor;
            AnnotationInstance annotation = annotationStore.getAnnotation((AnnotationTarget)info, ResteasyReactiveDotNames.PATH);
            if (annotation == null || !EndpointIndexer.hasProperModifiers(info) || seenMethods.contains(descriptor = EndpointIndexer.methodDescriptor(info))) continue;
            seenMethods.add(descriptor);
            ret.add(new FoundEndpoint(currentClassInfo, classNameBindings, info, null));
        }
        DotName dotName = currentClassInfo.superName();
        if (dotName != null && !dotName.equals((Object)ResteasyReactiveDotNames.OBJECT) && (superClass = index.getClassByName(dotName)) != null) {
            ret.addAll(EndpointIndexer.collectEndpoints(superClass, actualEndpointInfo, seenMethods, classNameBindings, considerApplication, httpAnnotationToMethod, index, applicationScanningResult, annotationStore));
        }
        List interfaces = currentClassInfo.interfaceNames();
        for (DotName i : interfaces) {
            ClassInfo superClass2 = index.getClassByName(i);
            if (superClass2 == null) continue;
            ret.addAll(EndpointIndexer.collectEndpoints(superClass2, actualEndpointInfo, seenMethods, classNameBindings, considerApplication, httpAnnotationToMethod, index, applicationScanningResult, annotationStore));
        }
        return ret;
    }

    protected String handleTrailingSlash(String path) {
        return path;
    }

    private void validateHttpAnnotations(MethodInfo info) {
        List annotationInstances = info.annotations();
        HashSet<DotName> allMethodAnnotations = new HashSet<DotName>(annotationInstances.size());
        for (AnnotationInstance instance : annotationInstances) {
            allMethodAnnotations.add(instance.name());
        }
        int httpAnnotationCount = 0;
        for (DotName dotName : allMethodAnnotations) {
            if (this.httpAnnotationToMethod.containsKey(dotName)) {
                ++httpAnnotationCount;
            }
            if (httpAnnotationCount <= 1) continue;
            throw new DeploymentException("Method '" + info.name() + "' of class '" + info.declaringClass().name() + "' contains multiple HTTP method annotations.");
        }
    }

    private static boolean hasProperModifiers(MethodInfo info) {
        if (EndpointIndexer.isSynthetic(info.flags())) {
            log.debug((Object)("Method '" + info.name() + " of Resource class '" + info.declaringClass().name() + "' is a synthetic method and will therefore be ignored"));
            return false;
        }
        if ((info.flags() & 1) == 0) {
            log.warn((Object)("Method '" + info.name() + " of Resource class '" + info.declaringClass().name() + "' is not public and will therefore be ignored"));
            return false;
        }
        if ((info.flags() & 8) != 0) {
            log.warn((Object)("Method '" + info.name() + " of Resource class '" + info.declaringClass().name() + "' is static and will therefore be ignored"));
            return false;
        }
        return true;
    }

    private static boolean isSynthetic(int mod) {
        return (mod & 0x1000) != 0;
    }

    private ResourceMethod createResourceMethod(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, BasicResourceClassInfo basicResourceClassInfo, Set<String> classNameBindings, DotName httpMethod, MethodInfo currentMethodInfo, String methodPath) {
        try {
            MethodInfo actualMethodInfo;
            String[] produces;
            Type methodContextReturnTypeOrReturnType;
            HashMap<String, Object> methodContext = new HashMap<String, Object>();
            methodContext.put(METHOD_CONTEXT_ANNOTATION_STORE, this.getAnnotationStore());
            HashSet<String> pathParameters = new HashSet<String>(basicResourceClassInfo.getPathParameters());
            URLUtils.parsePathParameters((String)methodPath, pathParameters);
            Map[] parameterAnnotations = new Map[currentMethodInfo.parametersCount()];
            MethodParameter[] methodParameters = new MethodParameter[currentMethodInfo.parametersCount()];
            for (int paramPos = 0; paramPos < currentMethodInfo.parametersCount(); ++paramPos) {
                parameterAnnotations[paramPos] = new HashMap();
            }
            for (AnnotationInstance i : this.getAnnotationStore().getAnnotations((AnnotationTarget)currentMethodInfo)) {
                if (i.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER) continue;
                parameterAnnotations[i.target().asMethodParameter().position()].put(i.name(), i);
            }
            String[] consumes = EndpointIndexer.extractProducesConsumesValues(this.getAnnotationStore().getAnnotation((AnnotationTarget)currentMethodInfo, ResteasyReactiveDotNames.CONSUMES), basicResourceClassInfo.getConsumes());
            boolean suspended = false;
            boolean sse = false;
            boolean formParamRequired = this.getAnnotationStore().getAnnotation((AnnotationTarget)currentMethodInfo, ResteasyReactiveDotNames.WITH_FORM_READ) != null;
            HashSet<String> fileFormNames = new HashSet<String>();
            Type bodyParamType = null;
            TypeArgMapper typeArgMapper = new TypeArgMapper(currentMethodInfo.declaringClass(), this.index);
            for (int i = 0; i < methodParameters.length; ++i) {
                String[] anns = parameterAnnotations[i];
                IndexedParameter parameterResult = null;
                int encoded = anns.containsKey(ResteasyReactiveDotNames.ENCODED);
                Type paramType = currentMethodInfo.parameterType(i);
                String errorLocation = "method " + currentMethodInfo + " on class " + currentMethodInfo.declaringClass();
                parameterResult = this.skipParameter((Map<DotName, AnnotationInstance>)anns) ? ((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)this.createIndexedParam()).setCurrentClassInfo(currentClassInfo)).setActualEndpointInfo(actualEndpointInfo)).setExistingConverters(this.existingConverters)).setAdditionalReaders(this.additionalReaders)).setAnns((Map<DotName, AnnotationInstance>)anns)).setParamType(paramType)).setErrorLocation(errorLocation)).setField(false)).setHasRuntimeConverters(this.hasRuntimeConverters)).setPathParameters(pathParameters)).setSourceName(currentMethodInfo.parameterName(i))).setType(ParameterType.SKIPPED) : (IndexedParameter)this.extractParameterInfo(currentClassInfo, actualEndpointInfo, currentMethodInfo, this.existingConverters, this.additionalReaders, (Map<DotName, AnnotationInstance>)anns, paramType, errorLocation, false, this.hasRuntimeConverters, pathParameters, currentMethodInfo.parameterName(i), consumes, methodContext);
                suspended |= parameterResult.isSuspended();
                sse |= parameterResult.isSse();
                String name = parameterResult.getName();
                String defaultValue = parameterResult.getDefaultValue();
                ParameterType type = parameterResult.getType();
                if (type == ParameterType.BODY) {
                    if (bodyParamType != null) {
                        throw new RuntimeException("Resource method " + currentMethodInfo + " can only have a single body parameter: " + currentMethodInfo.parameterName(i));
                    }
                    bodyParamType = paramType;
                }
                String elementType = parameterResult.getElementType();
                boolean single = parameterResult.isSingle();
                if (defaultValue == null && paramType.kind() == Type.Kind.PRIMITIVE) {
                    defaultValue = "0";
                }
                methodParameters[i] = this.createMethodParameter(currentClassInfo, actualEndpointInfo, encoded != 0, paramType, parameterResult, name, defaultValue, type, elementType, single, AsmUtil.getSignature(paramType, typeArgMapper), fileFormNames);
                if (type == ParameterType.BEAN || type == ParameterType.MULTI_PART_FORM) {
                    formParamRequired |= this.handleBeanParam(actualEndpointInfo, paramType, methodParameters, i, fileFormNames);
                    continue;
                }
                if (type != ParameterType.FORM && type != ParameterType.MULTI_PART_DATA_INPUT) continue;
                formParamRequired = true;
            }
            if (formParamRequired) {
                if (bodyParamType != null && !bodyParamType.name().equals((Object)ResteasyReactiveDotNames.MULTI_VALUED_MAP) && !bodyParamType.name().equals((Object)ResteasyReactiveDotNames.STRING)) {
                    throw new RuntimeException("'@FormParam' and '@RestForm' cannot be used in a resource method that contains a body parameter. Offending method is '" + currentMethodInfo.declaringClass().name() + "#" + currentMethodInfo + "'");
                }
                boolean validConsumes = false;
                if (consumes != null && consumes.length > 0) {
                    for (String c : consumes) {
                        if (!c.startsWith("multipart/form-data") && !c.startsWith("application/x-www-form-urlencoded")) continue;
                        validConsumes = true;
                        break;
                    }
                    if (!validConsumes) {
                        throw new RuntimeException("'@FormParam' and '@RestForm' can only be used on methods annotated with '@Consumes(MediaType.MULTIPART_FORM_DATA)' '@Consumes(MediaType.APPLICATION_FORM_URLENCODED)'. Offending method is '" + currentMethodInfo.declaringClass().name() + "#" + currentMethodInfo + "'");
                    }
                }
            }
            Type type = methodContextReturnTypeOrReturnType = methodContext.containsKey(METHOD_CONTEXT_CUSTOM_RETURN_TYPE_KEY) ? (Type)methodContext.get(METHOD_CONTEXT_CUSTOM_RETURN_TYPE_KEY) : currentMethodInfo.returnType();
            if (ResteasyReactiveDotNames.REST_RESPONSE.equals((Object)methodContextReturnTypeOrReturnType.name()) && methodContextReturnTypeOrReturnType.kind() == Type.Kind.CLASS) {
                log.warn((Object)("Method '" + currentMethodInfo.name() + " of Resource class '" + currentMethodInfo.declaringClass().name() + "' returns RestResponse but does not declare a generic type. It is strongly advised to define the generic type otherwise the behavior could be unpredictable"));
            }
            Type nonAsyncReturnType = this.getNonAsyncReturnType(methodContextReturnTypeOrReturnType);
            this.addWriterForType(this.additionalWriters, nonAsyncReturnType);
            String streamElementType = basicResourceClassInfo.getStreamElementType();
            String streamElementTypeInMethod = this.getStreamAnnotationValue((AnnotationTarget)currentMethodInfo);
            if (streamElementTypeInMethod != null) {
                streamElementType = streamElementTypeInMethod;
            }
            if (((produces = EndpointIndexer.extractProducesConsumesValues(this.getAnnotationStore().getAnnotation((AnnotationTarget)currentMethodInfo, ResteasyReactiveDotNames.PRODUCES))) == null || produces.length == 0) && streamElementType != null) {
                produces = new String[]{"text/event-stream"};
            } else if (produces == null || produces.length == 0) {
                produces = basicResourceClassInfo.getProduces();
            }
            produces = this.applyDefaultProducesAndAddCharsets(httpMethod, nonAsyncReturnType, produces);
            boolean returnsMultipart = false;
            if (produces != null && produces.length == 1) {
                if (streamElementType == null && "text/event-stream".equals(produces[0])) {
                    String[] defaultProducesForType = this.applyAdditionalDefaults(nonAsyncReturnType);
                    if (defaultProducesForType.length == 1) {
                        streamElementType = defaultProducesForType[0];
                    }
                } else if ("multipart/form-data".equals(produces[0])) {
                    if (ResteasyReactiveDotNames.RESPONSE.equals((Object)nonAsyncReturnType.name())) {
                        throw new DeploymentException(String.format("Endpoints that produce a Multipart result cannot return '%s' - consider returning '%s' instead. Offending method is '%s'", ResteasyReactiveDotNames.RESPONSE, ResteasyReactiveDotNames.REST_RESPONSE, currentMethodInfo.declaringClass().name() + "#" + currentMethodInfo));
                    }
                    ClassInfo multipartClassInfo = this.index.getClassByName(nonAsyncReturnType.name());
                    returnsMultipart = this.multipartReturnTypeIndexerExtension.handleMultipartForReturnType(this.additionalWriters, multipartClassInfo, this.index);
                }
            }
            Set<String> nameBindingNames = this.nameBindingNames(currentMethodInfo, classNameBindings);
            boolean blocking = this.isBlocking(currentMethodInfo, this.defaultBlocking);
            boolean runOnVirtualThread = this.isRunOnVirtualThread(currentMethodInfo, this.defaultBlocking);
            if (!actualEndpointInfo.equals(currentClassInfo) && Modifier.isInterface(currentClassInfo.flags()) && (actualMethodInfo = actualEndpointInfo.method(currentMethodInfo.name(), currentMethodInfo.parameterTypes().toArray(new Type[0]))) != null) {
                blocking = this.isBlocking(actualMethodInfo, blocking ? BlockingDefault.BLOCKING : BlockingDefault.NON_BLOCKING);
                runOnVirtualThread = this.isRunOnVirtualThread(actualMethodInfo, blocking ? BlockingDefault.BLOCKING : BlockingDefault.NON_BLOCKING);
            }
            if (returnsMultipart && !blocking) {
                throw new DeploymentException("Endpoints that produce a Multipart result can only be used on blocking methods. Offending method is '" + currentMethodInfo.declaringClass().name() + "#" + currentMethodInfo + "'");
            }
            methodContext.put(METHOD_PRODUCES, produces);
            ResourceMethod method = this.createResourceMethod(currentMethodInfo, actualEndpointInfo, methodContext).setHttpMethod(httpMethod == null ? null : this.httpAnnotationToMethod.get(httpMethod)).setPath(this.sanitizePath(methodPath)).setConsumes(consumes).setProduces(produces).setNameBindingNames(nameBindingNames).setName(currentMethodInfo.name()).setBlocking(blocking).setRunOnVirtualThread(runOnVirtualThread).setSuspended(suspended).setSse(sse).setEncoded(currentMethodInfo.hasDeclaredAnnotation(ResteasyReactiveDotNames.ENCODED)).setStreamElementType(streamElementType).setFormParamRequired(formParamRequired).setFileFormNames(fileFormNames).setParameters(methodParameters).setSimpleReturnType(EndpointIndexer.toClassName(currentMethodInfo.returnType(), currentClassInfo, actualEndpointInfo, this.index)).setReturnType(this.determineReturnType(methodContextReturnTypeOrReturnType, typeArgMapper, currentClassInfo, actualEndpointInfo, this.index));
            if (httpMethod == null) {
                this.handleClientSubResource(method, currentMethodInfo, this.index);
            }
            this.handleAdditionalMethodProcessing(method, currentClassInfo, currentMethodInfo, this.getAnnotationStore());
            if (this.resourceMethodCallback != null) {
                this.resourceMethodCallback.accept(new ResourceMethodCallbackEntry(this, this.index, basicResourceClassInfo, actualEndpointInfo, currentMethodInfo, method));
            }
            return method;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process method '" + currentMethodInfo.declaringClass().name() + "#" + currentMethodInfo.name() + "'", e);
        }
    }

    protected boolean skipParameter(Map<DotName, AnnotationInstance> anns) {
        return this.skipMethodParameter != null && this.skipMethodParameter.test(anns);
    }

    private String[] applyDefaultProducesAndAddCharsets(DotName httpMethod, Type nonAsyncReturnType, String[] produces) {
        return this.addDefaultCharsets(this.applyDefaultProduces(produces, nonAsyncReturnType, httpMethod));
    }

    protected void handleClientSubResource(ResourceMethod resourceMethod, MethodInfo method, IndexView index) {
    }

    private String getStreamAnnotationValue(AnnotationTarget target) {
        String value = this.getAnnotationValueAsString(target, ResteasyReactiveDotNames.REST_STREAM_ELEMENT_TYPE);
        if (value == null) {
            value = this.getAnnotationValueAsString(target, ResteasyReactiveDotNames.REST_SSE_ELEMENT_TYPE);
        }
        return value;
    }

    private String getAnnotationValueAsString(AnnotationTarget target, DotName annotationType) {
        String value = null;
        AnnotationInstance annotation = this.getAnnotationStore().getAnnotation(target, annotationType);
        if (annotation != null) {
            value = annotation.value().asString();
        }
        return value;
    }

    private boolean isRunOnVirtualThread(MethodInfo info, BlockingDefault defaultValue) {
        boolean isRunOnVirtualThread = false;
        Map.Entry<AnnotationTarget, AnnotationInstance> runOnVirtualThreadAnnotation = this.getInheritableAnnotation(info, ResteasyReactiveDotNames.RUN_ON_VIRTUAL_THREAD);
        Map.Entry<AnnotationTarget, AnnotationInstance> transactional = this.getInheritableAnnotation(info, ResteasyReactiveDotNames.TRANSACTIONAL);
        if (transactional != null) {
            return false;
        }
        if (runOnVirtualThreadAnnotation != null) {
            if (!JDK_SUPPORTS_VIRTUAL_THREADS) {
                throw new DeploymentException("Method '" + info.name() + "' of class '" + info.declaringClass().name() + "' uses @RunOnVirtualThread but the JDK version '" + Runtime.version() + "' and doesn't support virtual threads");
            }
            if (this.targetJavaVersion.isJava19OrHigher() == TargetJavaVersion.Status.FALSE) {
                throw new DeploymentException("Method '" + info.name() + "' of class '" + info.declaringClass().name() + "' uses @RunOnVirtualThread but the target JDK version doesn't support virtual threads. Please configure your build tool to target Java 19 or above");
            }
            isRunOnVirtualThread = true;
        }
        if (defaultValue == BlockingDefault.BLOCKING) {
            return false;
        }
        if (defaultValue == BlockingDefault.RUN_ON_VIRTUAL_THREAD) {
            isRunOnVirtualThread = true;
        } else if (defaultValue == BlockingDefault.NON_BLOCKING) {
            return false;
        }
        if (isRunOnVirtualThread && !this.isBlocking(info, defaultValue)) {
            throw new DeploymentException("Method '" + info.name() + "' of class '" + info.declaringClass().name() + "' is considered a non blocking method. @RunOnVirtualThread can only be used on  methods considered blocking");
        }
        return isRunOnVirtualThread;
    }

    private boolean isBlocking(MethodInfo info, BlockingDefault defaultValue) {
        Map.Entry<AnnotationTarget, AnnotationInstance> blockingAnnotation = this.getInheritableAnnotation(info, ResteasyReactiveDotNames.BLOCKING);
        Map.Entry<AnnotationTarget, AnnotationInstance> runOnVirtualThreadAnnotation = this.getInheritableAnnotation(info, ResteasyReactiveDotNames.RUN_ON_VIRTUAL_THREAD);
        Map.Entry<AnnotationTarget, AnnotationInstance> nonBlockingAnnotation = this.getInheritableAnnotation(info, ResteasyReactiveDotNames.NON_BLOCKING);
        if (blockingAnnotation != null && nonBlockingAnnotation != null) {
            if (blockingAnnotation.getKey().kind() == nonBlockingAnnotation.getKey().kind()) {
                if (blockingAnnotation.getKey().kind() == AnnotationTarget.Kind.METHOD) {
                    throw new DeploymentException("Method '" + info.name() + "' of class '" + info.declaringClass().name() + "' contains both @Blocking and @NonBlocking annotations.");
                }
                throw new DeploymentException("Class '" + info.declaringClass().name() + "' contains both @Blocking and @NonBlocking annotations.");
            }
            return blockingAnnotation.getKey().kind() == AnnotationTarget.Kind.METHOD;
        }
        if (blockingAnnotation != null) {
            return true;
        }
        if (nonBlockingAnnotation != null) {
            return false;
        }
        Map.Entry<AnnotationTarget, AnnotationInstance> transactional = this.getInheritableAnnotation(info, ResteasyReactiveDotNames.TRANSACTIONAL);
        if (transactional != null) {
            return true;
        }
        if (defaultValue == BlockingDefault.BLOCKING) {
            return true;
        }
        if (defaultValue == BlockingDefault.RUN_ON_VIRTUAL_THREAD) {
            return false;
        }
        if (defaultValue == BlockingDefault.NON_BLOCKING) {
            return false;
        }
        return this.doesMethodHaveBlockingSignature(info);
    }

    protected boolean doesMethodHaveBlockingSignature(MethodInfo info) {
        return true;
    }

    private String determineReturnType(Type returnType, TypeArgMapper typeArgMapper, ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, IndexView index) {
        if (returnType.kind() == Type.Kind.TYPE_VARIABLE) {
            returnType = EndpointIndexer.resolveTypeVariable(returnType.asTypeVariable(), currentClassInfo, actualEndpointInfo, index);
        }
        return AsmUtil.getSignature(returnType, typeArgMapper);
    }

    protected abstract boolean handleBeanParam(ClassInfo var1, Type var2, MethodParameter[] var3, int var4, Set<String> var5);

    protected void handleAdditionalMethodProcessing(METHOD method, ClassInfo currentClassInfo, MethodInfo info, AnnotationStore annotationStore) {
    }

    public boolean additionalRegisterClassForReflectionCheck(ResourceMethodCallbackEntry entry) {
        return false;
    }

    protected abstract InjectableBean scanInjectableBean(ClassInfo var1, ClassInfo var2, Map<String, String> var3, AdditionalReaders var4, Map<String, InjectableBean> var5, boolean var6);

    protected abstract MethodParameter createMethodParameter(ClassInfo var1, ClassInfo var2, boolean var3, Type var4, PARAM var5, String var6, String var7, ParameterType var8, String var9, boolean var10, String var11, Set<String> var12);

    private String[] applyDefaultProduces(String[] produces, Type nonAsyncReturnType, DotName httpMethod) {
        this.setupApplyDefaults(nonAsyncReturnType, httpMethod);
        if (produces != null && produces.length != 0) {
            return produces;
        }
        return this.applyAdditionalDefaults(nonAsyncReturnType);
    }

    private String[] addDefaultCharsets(String[] produces) {
        if (produces == null || produces.length == 0) {
            return produces;
        }
        ArrayList<Object> result = new ArrayList<Object>(produces.length);
        for (String p : produces) {
            if (p.equals("text/plain")) {
                result.add("text/plain;charset=" + StandardCharsets.UTF_8.name());
                continue;
            }
            result.add(p);
        }
        return result.toArray(EMPTY_STRING_ARRAY);
    }

    protected void setupApplyDefaults(Type nonAsyncReturnType, DotName httpMethod) {
    }

    protected String[] applyAdditionalDefaults(Type nonAsyncReturnType) {
        if (ResteasyReactiveDotNames.STRING.equals((Object)nonAsyncReturnType.name())) {
            return this.config.isSingleDefaultProduces() ? PRODUCES_PLAIN_TEXT : PRODUCES_PLAIN_TEXT_NEGOTIATED;
        }
        return EMPTY_STRING_ARRAY;
    }

    private Type getNonAsyncReturnType(Type returnType) {
        switch (returnType.kind()) {
            case ARRAY: 
            case CLASS: 
            case PRIMITIVE: 
            case VOID: {
                return returnType;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = returnType.asParameterizedType();
                if (ResteasyReactiveDotNames.COMPLETION_STAGE.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.COMPLETABLE_FUTURE.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.UNI.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.MULTI.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.REST_MULTI.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.REST_RESPONSE.equals((Object)parameterizedType.name())) {
                    return (Type)parameterizedType.arguments().get(0);
                }
                return returnType;
            }
        }
        return returnType;
    }

    protected abstract void addWriterForType(AdditionalWriters var1, Type var2);

    protected abstract void addReaderForType(AdditionalReaders var1, Type var2);

    private static <T> Class<T> getSupportedReaderJavaClass(Type paramType) {
        Class<?> result = supportedReaderJavaTypes.get(paramType.name());
        return Objects.requireNonNull(result);
    }

    private Map.Entry<AnnotationTarget, AnnotationInstance> getInheritableAnnotation(MethodInfo info, DotName name) {
        AnnotationInstance annotation = this.getAnnotationStore().getAnnotation((AnnotationTarget)info, name);
        MethodInfo target = info;
        if (annotation == null) {
            annotation = this.getAnnotationStore().getAnnotation((AnnotationTarget)info.declaringClass(), name);
            target = info.declaringClass();
        }
        return annotation != null ? new AbstractMap.SimpleEntry<MethodInfo, AnnotationInstance>(target, annotation) : null;
    }

    private static String methodDescriptor(MethodInfo info) {
        return info.name() + ":" + info.descriptor();
    }

    private static boolean moreThanOne(AnnotationInstance ... annotations) {
        boolean oneNonNull = false;
        for (AnnotationInstance annotation : annotations) {
            if (annotation == null) continue;
            if (oneNonNull) {
                return true;
            }
            oneNonNull = true;
        }
        return false;
    }

    public static String[] extractProducesConsumesValues(AnnotationInstance annotation, String[] defaultValue) {
        String[] read = EndpointIndexer.extractProducesConsumesValues(annotation);
        if (read == null) {
            return defaultValue;
        }
        return read;
    }

    private static String[] extractProducesConsumesValues(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        AnnotationValue value = annotation.value();
        String[] originalStrings = value == null ? new String[]{"*/*"} : value.asStringArray();
        if (originalStrings.length > 0) {
            ArrayList<String> result = new ArrayList<String>(originalStrings.length);
            for (String s : originalStrings) {
                String[] trimmed;
                for (String t : trimmed = s.split(",")) {
                    result.add(t.trim());
                }
            }
            return result.toArray(EMPTY_STRING_ARRAY);
        }
        return originalStrings;
    }

    private static String readStringValue(AnnotationInstance annotationInstance) {
        if (annotationInstance != null) {
            return annotationInstance.value().asString();
        }
        return null;
    }

    protected static String toClassName(Type indexType, ClassInfo currentClass, ClassInfo actualEndpointClass, IndexView indexView) {
        switch (indexType.kind()) {
            case VOID: {
                return "void";
            }
            case CLASS: {
                return indexType.asClassType().name().toString();
            }
            case PRIMITIVE: {
                return indexType.asPrimitiveType().primitive().name().toLowerCase(Locale.ENGLISH);
            }
            case PARAMETERIZED_TYPE: {
                return indexType.asParameterizedType().name().toString();
            }
            case ARRAY: {
                return indexType.asArrayType().name().toString();
            }
            case WILDCARD_TYPE: {
                WildcardType wildcardType = indexType.asWildcardType();
                Type extendsBound = wildcardType.extendsBound();
                if (extendsBound.name().equals((Object)ResteasyReactiveDotNames.OBJECT)) {
                    throw new RuntimeException("Cannot handle wildcard type " + indexType);
                }
                return wildcardType.name().toString();
            }
            case TYPE_VARIABLE: {
                TypeVariable typeVariable = indexType.asTypeVariable();
                if (typeVariable.bounds().isEmpty()) {
                    return Object.class.getName();
                }
                return EndpointIndexer.toClassName(EndpointIndexer.resolveTypeVariable(typeVariable, currentClass, actualEndpointClass, indexView), currentClass, actualEndpointClass, indexView);
            }
        }
        throw new RuntimeException("Unknown parameter type " + indexType);
    }

    private static Type resolveTypeVariable(TypeVariable typeVariable, ClassInfo currentClass, ClassInfo actualEndpointClass, IndexView indexView) {
        Type resolved;
        if (typeVariable.bounds().isEmpty()) {
            return Type.create((DotName)DotName.createSimple((String)Object.class.getName()), (Type.Kind)Type.Kind.CLASS);
        }
        int pos = -1;
        List typeVariables = currentClass.typeParameters();
        for (int i = 0; i < typeVariables.size(); ++i) {
            if (!((TypeVariable)typeVariables.get(i)).identifier().equals(typeVariable.identifier())) continue;
            pos = i;
            break;
        }
        if (!(pos == -1 || (resolved = EndpointIndexer.resolveTypeParameters(pos, actualEndpointClass, currentClass, indexView)) == null || resolved.kind() == Type.Kind.TYPE_VARIABLE && resolved.asTypeVariable().identifier().equals(typeVariable.identifier()))) {
            return resolved;
        }
        return (Type)typeVariable.bounds().get(0);
    }

    private static Type resolveTypeParameters(int position, ClassInfo actualEndpointClass, ClassInfo currentClass, IndexView indexView) {
        List<Type> params = JandexUtil.resolveTypeParameters(actualEndpointClass.name(), currentClass.name(), indexView);
        if (position < params.size()) {
            return params.get(position);
        }
        for (MethodInfo method : actualEndpointClass.methods()) {
            for (int paramIndex = 0; paramIndex < method.parametersCount(); ++paramIndex) {
                ParameterizedType parameterizedType;
                Type paramType = method.parameterType(paramIndex);
                if (paramType.kind() != Type.Kind.PARAMETERIZED_TYPE || !(parameterizedType = paramType.asParameterizedType()).name().equals((Object)currentClass.name()) || position >= parameterizedType.arguments().size()) continue;
                return (Type)parameterizedType.arguments().get(position);
            }
        }
        return null;
    }

    private static String appendPath(String prefix, String suffix) {
        if (prefix == null) {
            return suffix;
        }
        if (suffix == null) {
            return prefix;
        }
        if (prefix.endsWith("/") && !suffix.startsWith("/") || !prefix.endsWith("/") && suffix.startsWith("/")) {
            return prefix + suffix;
        }
        if (prefix.endsWith("/")) {
            return prefix.substring(0, prefix.length() - 1) + suffix;
        }
        return prefix + "/" + suffix;
    }

    protected abstract PARAM createIndexedParam();

    public PARAM extractParameterInfo(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, MethodInfo currentMethodInfo, Map<String, String> existingConverters, AdditionalReaders additionalReaders, Map<DotName, AnnotationInstance> anns, Type paramType, String errorLocation, boolean field, boolean hasRuntimeConverters, Set<String> pathParameters, String sourceName, String[] declaredConsumes, Map<String, Object> methodContext) {
        Object builder = ((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)this.createIndexedParam()).setCurrentClassInfo(currentClassInfo)).setActualEndpointInfo(actualEndpointInfo)).setExistingConverters(existingConverters)).setAdditionalReaders(additionalReaders)).setAnns(anns)).setParamType(paramType)).setErrorLocation(errorLocation)).setField(field)).setHasRuntimeConverters(hasRuntimeConverters)).setPathParameters(pathParameters)).setSourceName(sourceName);
        AnnotationInstance beanParam = anns.get(ResteasyReactiveDotNames.BEAN_PARAM);
        AnnotationInstance multiPartFormParam = anns.get(ResteasyReactiveDotNames.MULTI_PART_FORM_PARAM);
        AnnotationInstance pathParam = anns.get(ResteasyReactiveDotNames.PATH_PARAM);
        AnnotationInstance queryParam = anns.get(ResteasyReactiveDotNames.QUERY_PARAM);
        AnnotationInstance headerParam = anns.get(ResteasyReactiveDotNames.HEADER_PARAM);
        AnnotationInstance formParam = anns.get(ResteasyReactiveDotNames.FORM_PARAM);
        AnnotationInstance matrixParam = anns.get(ResteasyReactiveDotNames.MATRIX_PARAM);
        AnnotationInstance cookieParam = anns.get(ResteasyReactiveDotNames.COOKIE_PARAM);
        AnnotationInstance restPathParam = anns.get(ResteasyReactiveDotNames.REST_PATH_PARAM);
        AnnotationInstance restQueryParam = anns.get(ResteasyReactiveDotNames.REST_QUERY_PARAM);
        AnnotationInstance restHeaderParam = anns.get(ResteasyReactiveDotNames.REST_HEADER_PARAM);
        AnnotationInstance restFormParam = anns.get(ResteasyReactiveDotNames.REST_FORM_PARAM);
        AnnotationInstance restMatrixParam = anns.get(ResteasyReactiveDotNames.REST_MATRIX_PARAM);
        AnnotationInstance restCookieParam = anns.get(ResteasyReactiveDotNames.REST_COOKIE_PARAM);
        AnnotationInstance contextParam = anns.get(ResteasyReactiveDotNames.CONTEXT);
        AnnotationInstance defaultValueAnnotation = anns.get(ResteasyReactiveDotNames.DEFAULT_VALUE);
        AnnotationInstance suspendedAnnotation = anns.get(ResteasyReactiveDotNames.SUSPENDED);
        boolean convertible = false;
        if (defaultValueAnnotation != null) {
            ((IndexedParameter)builder).setDefaultValue(defaultValueAnnotation.value().asString());
        }
        if (this.handleCustomParameter(anns, builder, paramType, field, methodContext)) {
            return (PARAM)builder;
        }
        if (EndpointIndexer.moreThanOne(pathParam, queryParam, headerParam, formParam, cookieParam, contextParam, beanParam, restPathParam, restQueryParam, restHeaderParam, restFormParam, restCookieParam)) {
            throw new RuntimeException("Cannot have more than one of @PathParam, @QueryParam, @HeaderParam, @FormParam, @CookieParam, @BeanParam, @Context on " + errorLocation);
        }
        if (pathParam != null) {
            ((IndexedParameter)builder).setName(pathParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.PATH);
            convertible = true;
        } else if (restPathParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restPathParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.PATH);
            convertible = true;
        } else if (queryParam != null) {
            ((IndexedParameter)builder).setName(queryParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.QUERY);
            ((IndexedParameter)builder).setSeparator(this.getSeparator(anns));
            convertible = true;
        } else if (restQueryParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restQueryParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.QUERY);
            ((IndexedParameter)builder).setSeparator(this.getSeparator(anns));
            convertible = true;
        } else if (cookieParam != null) {
            ((IndexedParameter)builder).setName(cookieParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.COOKIE);
            convertible = true;
        } else if (restCookieParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restCookieParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.COOKIE);
            convertible = true;
        } else if (headerParam != null) {
            ((IndexedParameter)builder).setName(headerParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.HEADER);
            convertible = true;
        } else if (restHeaderParam != null) {
            if (restHeaderParam.value() == null || restHeaderParam.value().asString().isEmpty()) {
                ((IndexedParameter)builder).setName(StringUtil.hyphenateWithCapitalFirstLetter(sourceName));
            } else {
                ((IndexedParameter)builder).setName(restHeaderParam.value().asString());
            }
            ((IndexedParameter)builder).setType(ParameterType.HEADER);
            convertible = true;
        } else if (formParam != null) {
            ((IndexedParameter)builder).setName(formParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.FORM);
            convertible = this.isFormParamConvertible(paramType);
        } else if (restFormParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restFormParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.FORM);
            convertible = this.isFormParamConvertible(paramType);
        } else if (matrixParam != null) {
            ((IndexedParameter)builder).setName(matrixParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.MATRIX);
            convertible = true;
        } else if (restMatrixParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restMatrixParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.MATRIX);
            convertible = true;
        } else if (contextParam != null) {
            if (field) {
                return (PARAM)builder;
            }
            ((IndexedParameter)builder).setType(ParameterType.CONTEXT);
        } else if (beanParam != null) {
            ((IndexedParameter)builder).setType(ParameterType.BEAN);
        } else if (multiPartFormParam != null) {
            ((IndexedParameter)builder).setType(ParameterType.MULTI_PART_FORM);
        } else if (suspendedAnnotation != null) {
            ((IndexedParameter)builder).setType(ParameterType.ASYNC_RESPONSE);
            ((IndexedParameter)builder).setSuspended(true);
        } else if (!field && paramType.kind() == Type.Kind.CLASS && this.isContextType(paramType.asClassType())) {
            ((IndexedParameter)builder).setType(ParameterType.CONTEXT);
        } else if (!field && paramType.kind() == Type.Kind.CLASS && this.isParameterContainerType(paramType.asClassType())) {
            ((IndexedParameter)builder).setType(ParameterType.BEAN);
        } else if (!field && pathParameters.contains(sourceName)) {
            ((IndexedParameter)builder).setName(sourceName);
            ((IndexedParameter)builder).setType(ParameterType.PATH);
            ((IndexedParameter)builder).setErrorLocation(((IndexedParameter)builder).getErrorLocation() + " (this parameter name matches the @Path parameter name, so it has been implicitly assumed to be an @PathParam and not the request body)");
            convertible = true;
        } else {
            if (!field && paramType.name().equals((Object)ResteasyReactiveDotNames.MULTI_PART_DATA_INPUT)) {
                ((IndexedParameter)builder).setType(ParameterType.MULTI_PART_DATA_INPUT);
                ((IndexedParameter)builder).setSingle(true);
                return (PARAM)builder;
            }
            if (field) {
                return (PARAM)builder;
            }
            ((IndexedParameter)builder).setType(ParameterType.BODY);
        }
        ((IndexedParameter)builder).setSingle(true);
        boolean typeHandled = false;
        String elementType = null;
        ParameterType type = ((IndexedParameter)builder).getType();
        if (paramType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType pt = paramType.asParameterizedType();
            if (pt.name().equals((Object)ResteasyReactiveDotNames.LIST)) {
                typeHandled = true;
                ((IndexedParameter)builder).setSingle(false);
                elementType = EndpointIndexer.toClassName((Type)pt.arguments().get(0), currentClassInfo, actualEndpointInfo, this.index);
                if (convertible) {
                    this.handleListParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
                }
            } else if (pt.name().equals((Object)ResteasyReactiveDotNames.SET)) {
                typeHandled = true;
                ((IndexedParameter)builder).setSingle(false);
                elementType = EndpointIndexer.toClassName((Type)pt.arguments().get(0), currentClassInfo, actualEndpointInfo, this.index);
                if (convertible) {
                    this.handleSetParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
                }
            } else if (pt.name().equals((Object)ResteasyReactiveDotNames.SORTED_SET)) {
                typeHandled = true;
                ((IndexedParameter)builder).setSingle(false);
                elementType = EndpointIndexer.toClassName((Type)pt.arguments().get(0), currentClassInfo, actualEndpointInfo, this.index);
                if (convertible) {
                    this.handleSortedSetParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
                }
            } else if (pt.name().equals((Object)ResteasyReactiveDotNames.OPTIONAL)) {
                typeHandled = true;
                elementType = EndpointIndexer.toClassName((Type)pt.arguments().get(0), currentClassInfo, actualEndpointInfo, this.index);
                if (convertible) {
                    String genericElementType = null;
                    if (((Type)pt.arguments().get(0)).kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        genericElementType = EndpointIndexer.toClassName((Type)((Type)pt.arguments().get(0)).asParameterizedType().arguments().get(0), currentClassInfo, actualEndpointInfo, this.index);
                    }
                    this.handleOptionalParam(existingConverters, anns, errorLocation, hasRuntimeConverters, builder, elementType, genericElementType, currentMethodInfo);
                }
                ((IndexedParameter)builder).setOptional(true);
            } else if (convertible) {
                typeHandled = true;
                elementType = EndpointIndexer.toClassName((Type)pt, currentClassInfo, actualEndpointInfo, this.index);
                this.handleOtherParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
            } else if (((IndexedParameter)builder).getType() != ParameterType.BEAN) {
                elementType = ResteasyReactiveDotNames.DUMMY_ELEMENT_TYPE.toString();
                this.addReaderForType(additionalReaders, (Type)pt);
                typeHandled = true;
            }
        } else if (paramType.name().equals((Object)ResteasyReactiveDotNames.PATH_SEGMENT) && type == ParameterType.PATH) {
            elementType = paramType.name().toString();
            this.handlePathSegmentParam(builder);
            typeHandled = true;
        } else if (SUPPORT_TEMPORAL_PARAMS.contains(paramType.name()) && (type == ParameterType.PATH || type == ParameterType.QUERY || type == ParameterType.FORM || type == ParameterType.COOKIE || type == ParameterType.HEADER)) {
            elementType = paramType.name().toString();
            this.handleTemporalParam(builder, paramType.name(), anns, currentMethodInfo);
            typeHandled = true;
        } else if (paramType.name().equals((Object)ResteasyReactiveDotNames.LIST) && (type == ParameterType.QUERY || type == ParameterType.HEADER)) {
            elementType = String.class.getName();
            typeHandled = true;
            ((IndexedParameter)builder).setSingle(false);
            if (convertible) {
                this.handleListParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
            }
        } else if (paramType.name().equals((Object)ResteasyReactiveDotNames.SET) && type == ParameterType.HEADER) {
            elementType = String.class.getName();
            typeHandled = true;
            ((IndexedParameter)builder).setSingle(false);
            if (convertible) {
                this.handleSetParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
            }
        } else if (paramType.name().equals((Object)ResteasyReactiveDotNames.SORTED_SET) && type == ParameterType.HEADER) {
            elementType = String.class.getName();
            typeHandled = true;
            ((IndexedParameter)builder).setSingle(false);
            if (convertible) {
                this.handleSortedSetParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
            }
        } else if (paramType.kind() == Type.Kind.ARRAY) {
            ArrayType at = paramType.asArrayType();
            typeHandled = true;
            if (((IndexedParameter)builder).type != ParameterType.FORM || convertible) {
                ((IndexedParameter)builder).setSingle(false);
            }
            elementType = EndpointIndexer.toClassName(at.constituent(), currentClassInfo, actualEndpointInfo, this.index);
            if (convertible) {
                this.handleArrayParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
            }
        }
        if (!typeHandled) {
            elementType = EndpointIndexer.toClassName(paramType, currentClassInfo, actualEndpointInfo, this.index);
            this.addReaderForType(additionalReaders, paramType);
            if (type != ParameterType.CONTEXT && type != ParameterType.BEAN && type != ParameterType.BODY && type != ParameterType.ASYNC_RESPONSE && type != ParameterType.MULTI_PART_FORM) {
                this.handleOtherParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
            }
            if (type == ParameterType.CONTEXT && elementType.equals(SseEventSink.class.getName())) {
                ((IndexedParameter)builder).setSse(true);
            }
        }
        if (suspendedAnnotation != null && !elementType.equals(AsyncResponse.class.getName())) {
            throw new RuntimeException("Can only inject AsyncResponse on methods marked @Suspended");
        }
        if (((IndexedParameter)builder).isSingle() && ((IndexedParameter)builder).getSeparator() != null) {
            throw new DeploymentException("Single parameters should not be marked with @Separator");
        }
        ((IndexedParameter)builder).setElementType(elementType);
        return (PARAM)builder;
    }

    private boolean isFormParamConvertible(Type paramType) {
        return paramType.kind() != Type.Kind.ARRAY || paramType.asArrayType().constituent().kind() != Type.Kind.PRIMITIVE || paramType.asArrayType().constituent().asPrimitiveType().primitive() != PrimitiveType.Primitive.BYTE;
    }

    protected boolean handleCustomParameter(Map<DotName, AnnotationInstance> anns, PARAM builder, Type paramType, boolean field, Map<String, Object> methodContext) {
        return false;
    }

    protected void handlePathSegmentParam(PARAM builder) {
    }

    protected void handleTemporalParam(PARAM builder, DotName name, Map<DotName, AnnotationInstance> parameterAnnotations, MethodInfo currentMethodInfo) {
    }

    protected DeclaredTypes getDeclaredTypes(Type paramType, ClassInfo currentClassInfo, ClassInfo actualEndpointInfo) {
        TypeVariable typeVariable;
        String declaredType = EndpointIndexer.toClassName(paramType, currentClassInfo, actualEndpointInfo, this.index);
        String declaredUnresolvedType = paramType.kind() == Type.Kind.TYPE_VARIABLE ? ((typeVariable = paramType.asTypeVariable()).bounds().isEmpty() ? Object.class.getName() : ((Type)typeVariable.bounds().get(0)).name().toString()) : declaredType;
        return new DeclaredTypes(declaredType, declaredUnresolvedType);
    }

    protected void handleOtherParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected void handleSortedSetParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected void handleOptionalParam(Map<String, String> existingConverters, Map<DotName, AnnotationInstance> parameterAnnotations, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType, String genericElementType, MethodInfo currentMethodInfo) {
    }

    protected void handleSetParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected void handleListParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected void handleArrayParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    final boolean isContextType(ClassType klass) {
        return this.contextTypes.contains(klass.name());
    }

    final boolean isParameterContainerType(ClassType klass) {
        return this.parameterContainerTypes.contains(klass.name());
    }

    private String valueOrDefault(AnnotationValue annotation, String defaultValue) {
        if (annotation == null) {
            return defaultValue;
        }
        String val = annotation.asString();
        return val != null && !val.isEmpty() ? val : defaultValue;
    }

    public Set<String> nameBindingNames(ClassInfo selectedAppClass) {
        return NameBindingUtil.nameBindingNames(this.index, selectedAppClass);
    }

    public Set<String> nameBindingNames(MethodInfo methodInfo, Set<String> forClass) {
        return NameBindingUtil.nameBindingNames(this.index, methodInfo, forClass);
    }

    protected AnnotationStore getAnnotationStore() {
        return this.annotationStore;
    }

    protected String getPartMime(Map<DotName, AnnotationInstance> annotations) {
        AnnotationInstance partType = annotations.get(ResteasyReactiveDotNames.PART_TYPE_NAME);
        String mimeType = null;
        if (partType != null && partType.value() != null && "text/plain".equals(mimeType = partType.value().asString())) {
            mimeType = null;
        }
        return mimeType;
    }

    protected String getSeparator(Map<DotName, AnnotationInstance> annotations) {
        AnnotationInstance separator = annotations.get(ResteasyReactiveDotNames.SEPARATOR);
        String result = null;
        if (separator != null && separator.value() != null) {
            result = separator.value().asString();
        }
        return result;
    }

    static {
        DEFAULT_CONTEXT_TYPES = Set.of(ResteasyReactiveDotNames.URI_INFO, ResteasyReactiveDotNames.HTTP_HEADERS, ResteasyReactiveDotNames.REQUEST, ResteasyReactiveDotNames.SECURITY_CONTEXT, ResteasyReactiveDotNames.PROVIDERS, ResteasyReactiveDotNames.RESOURCE_CONTEXT, ResteasyReactiveDotNames.CONFIGURATION, ResteasyReactiveDotNames.SSE, ResteasyReactiveDotNames.SSE_EVENT_SINK, ResteasyReactiveDotNames.SERVER_REQUEST_CONTEXT, DotName.createSimple((String)"org.jboss.resteasy.reactive.server.SimpleResourceInfo"), ResteasyReactiveDotNames.RESOURCE_INFO);
        SUPPORT_TEMPORAL_PARAMS = Set.of(ResteasyReactiveDotNames.INSTANT, ResteasyReactiveDotNames.LOCAL_DATE, ResteasyReactiveDotNames.LOCAL_TIME, ResteasyReactiveDotNames.LOCAL_DATE_TIME, ResteasyReactiveDotNames.OFFSET_TIME, ResteasyReactiveDotNames.OFFSET_DATE_TIME, ResteasyReactiveDotNames.ZONED_DATE_TIME, ResteasyReactiveDotNames.YEAR);
        log = Logger.getLogger(EndpointIndexer.class);
        EMPTY_STRING_ARRAY = new String[0];
        PRODUCES_PLAIN_TEXT_NEGOTIATED = new String[]{"text/plain", "*/*"};
        PRODUCES_PLAIN_TEXT = new String[]{"text/plain"};
        primitiveTypes = Map.ofEntries(Map.entry(Byte.TYPE.getName(), Byte.class.getName()), Map.entry(Byte.class.getName(), Byte.class.getName()), Map.entry(Boolean.TYPE.getName(), Boolean.class.getName()), Map.entry(Boolean.class.getName(), Boolean.class.getName()), Map.entry(Character.TYPE.getName(), Character.class.getName()), Map.entry(Character.class.getName(), Character.class.getName()), Map.entry(Short.TYPE.getName(), Short.class.getName()), Map.entry(Short.class.getName(), Short.class.getName()), Map.entry(Integer.TYPE.getName(), Integer.class.getName()), Map.entry(Integer.class.getName(), Integer.class.getName()), Map.entry(Float.TYPE.getName(), Float.class.getName()), Map.entry(Float.class.getName(), Float.class.getName()), Map.entry(Double.TYPE.getName(), Double.class.getName()), Map.entry(Double.class.getName(), Double.class.getName()), Map.entry(Long.TYPE.getName(), Long.class.getName()), Map.entry(Long.class.getName(), Long.class.getName()));
        supportedReaderJavaTypes = Map.ofEntries(Map.entry(ResteasyReactiveDotNames.PRIMITIVE_BOOLEAN, Boolean.TYPE), Map.entry(ResteasyReactiveDotNames.PRIMITIVE_DOUBLE, Double.TYPE), Map.entry(ResteasyReactiveDotNames.PRIMITIVE_FLOAT, Float.TYPE), Map.entry(ResteasyReactiveDotNames.PRIMITIVE_LONG, Long.TYPE), Map.entry(ResteasyReactiveDotNames.PRIMITIVE_INTEGER, Integer.TYPE), Map.entry(ResteasyReactiveDotNames.PRIMITIVE_CHAR, Character.TYPE), Map.entry(ResteasyReactiveDotNames.BOOLEAN, Boolean.class), Map.entry(ResteasyReactiveDotNames.DOUBLE, Double.class), Map.entry(ResteasyReactiveDotNames.FLOAT, Float.class), Map.entry(ResteasyReactiveDotNames.LONG, Long.class), Map.entry(ResteasyReactiveDotNames.INTEGER, Integer.class), Map.entry(ResteasyReactiveDotNames.CHARACTER, Character.class), Map.entry(ResteasyReactiveDotNames.BIG_DECIMAL, BigDecimal.class), Map.entry(ResteasyReactiveDotNames.BIG_INTEGER, BigInteger.class));
        boolean isJDKCompatible = true;
        try {
            Class.forName("java.lang.ThreadBuilders");
        }
        catch (ClassNotFoundException e) {
            isJDKCompatible = false;
        }
        JDK_SUPPORTS_VIRTUAL_THREADS = isJDKCompatible;
    }

    private static final class FoundEndpoint {
        private final ClassInfo classInfo;
        private final Set<String> classNameBindings;
        private final MethodInfo methodInfo;
        private final DotName httpMethod;

        private FoundEndpoint(ClassInfo classInfo, Set<String> classNameBindings, MethodInfo methodInfo, DotName httpMethod) {
            this.classInfo = classInfo;
            this.classNameBindings = classNameBindings;
            this.methodInfo = methodInfo;
            this.httpMethod = httpMethod;
        }
    }

    public static interface MultipartParameterIndexerExtension {
        public void handleMultipartParameter(ClassInfo var1, IndexView var2);
    }

    public static interface MultipartReturnTypeIndexerExtension {
        public boolean handleMultipartForReturnType(AdditionalWriters var1, ClassInfo var2, IndexView var3);
    }

    public static class DeclaredTypes {
        private final String declaredType;
        private final String declaredUnresolvedType;

        public DeclaredTypes(String declaredType, String declaredUnresolvedType) {
            this.declaredType = declaredType;
            this.declaredUnresolvedType = declaredUnresolvedType;
        }

        public String getDeclaredType() {
            return this.declaredType;
        }

        public String getDeclaredUnresolvedType() {
            return this.declaredUnresolvedType;
        }
    }

    public static class ResourceMethodCallbackEntry {
        private final EndpointIndexer indexer;
        private final IndexView index;
        private final BasicResourceClassInfo basicResourceClassInfo;
        private final ClassInfo actualEndpointInfo;
        private final MethodInfo methodInfo;
        private final ResourceMethod resourceMethod;

        public ResourceMethodCallbackEntry(EndpointIndexer indexer, IndexView index, BasicResourceClassInfo basicResourceClassInfo, ClassInfo actualEndpointInfo, MethodInfo methodInfo, ResourceMethod resourceMethod) {
            this.indexer = indexer;
            this.index = index;
            this.basicResourceClassInfo = basicResourceClassInfo;
            this.methodInfo = methodInfo;
            this.actualEndpointInfo = actualEndpointInfo;
            this.resourceMethod = resourceMethod;
        }

        public BasicResourceClassInfo getBasicResourceClassInfo() {
            return this.basicResourceClassInfo;
        }

        public MethodInfo getMethodInfo() {
            return this.methodInfo;
        }

        public ClassInfo getActualEndpointInfo() {
            return this.actualEndpointInfo;
        }

        public ResourceMethod getResourceMethod() {
            return this.resourceMethod;
        }

        public boolean additionalRegisterClassForReflectionCheck() {
            return this.indexer.additionalRegisterClassForReflectionCheck(this);
        }
    }

    public static class BasicResourceClassInfo {
        private final String path;
        private final String[] produces;
        private final String[] consumes;
        private final Set<String> pathParameters;
        private final String streamElementType;

        public BasicResourceClassInfo(String path, String[] produces, String[] consumes, Set<String> pathParameters, String streamElementType) {
            this.path = path;
            this.produces = produces;
            this.consumes = consumes;
            this.pathParameters = pathParameters;
            this.streamElementType = streamElementType;
        }

        public String getPath() {
            return this.path;
        }

        public String[] getProduces() {
            return this.produces;
        }

        public String[] getConsumes() {
            return this.consumes;
        }

        public Set<String> getPathParameters() {
            return this.pathParameters;
        }

        public String getStreamElementType() {
            return this.streamElementType;
        }
    }

    public static abstract class Builder<T extends EndpointIndexer<T, ?, METHOD>, B extends Builder<T, B, METHOD>, METHOD extends ResourceMethod> {
        private Function<String, BeanFactory<Object>> factoryCreator;
        private BlockingDefault defaultBlocking = BlockingDefault.AUTOMATIC;
        private IndexView index;
        private IndexView applicationIndex;
        private Map<String, String> existingConverters = new HashMap<String, String>();
        private Map<DotName, String> scannedResourcePaths;
        private ResteasyReactiveConfig config;
        private AdditionalReaders additionalReaders;
        private Map<DotName, String> httpAnnotationToMethod;
        private Map<String, InjectableBean> injectableBeans;
        private AdditionalWriters additionalWriters;
        private boolean hasRuntimeConverters;
        private Map<DotName, Map<String, String>> classLevelExceptionMappers;
        private Consumer<ResourceMethodCallbackEntry> resourceMethodCallback;
        private Collection<AnnotationsTransformer> annotationsTransformers;
        private ApplicationScanningResult applicationScanningResult;
        private final Set<DotName> contextTypes = new HashSet<DotName>(DEFAULT_CONTEXT_TYPES);
        private final Set<DotName> parameterContainerTypes = new HashSet<DotName>();
        private MultipartReturnTypeIndexerExtension multipartReturnTypeIndexerExtension = new MultipartReturnTypeIndexerExtension(){

            @Override
            public boolean handleMultipartForReturnType(AdditionalWriters additionalWriters, ClassInfo multipartClassInfo, IndexView indexView) {
                return false;
            }
        };
        private TargetJavaVersion targetJavaVersion = new TargetJavaVersion.Unknown();
        private Function<ClassInfo, Supplier<Boolean>> isDisabledCreator = null;
        private Predicate<Map<DotName, AnnotationInstance>> skipMethodParameter = null;

        public B setMultipartReturnTypeIndexerExtension(MultipartReturnTypeIndexerExtension multipartReturnTypeHandler) {
            this.multipartReturnTypeIndexerExtension = multipartReturnTypeHandler;
            return (B)this;
        }

        public B setDefaultBlocking(BlockingDefault defaultBlocking) {
            this.defaultBlocking = defaultBlocking;
            return (B)this;
        }

        public B setHasRuntimeConverters(boolean hasRuntimeConverters) {
            this.hasRuntimeConverters = hasRuntimeConverters;
            return (B)this;
        }

        public B setIndex(IndexView index) {
            this.index = index;
            return (B)this;
        }

        public B setApplicationIndex(IndexView index) {
            this.applicationIndex = index;
            return (B)this;
        }

        public B addContextType(DotName contextType) {
            this.contextTypes.add(contextType);
            return (B)this;
        }

        public B addContextTypes(Collection<DotName> contextTypes) {
            this.contextTypes.addAll(contextTypes);
            return (B)this;
        }

        public B addParameterContainerType(DotName parameterContainerType) {
            this.parameterContainerTypes.add(parameterContainerType);
            return (B)this;
        }

        public B addParameterContainerTypes(Collection<DotName> parameterContainerTypes) {
            this.parameterContainerTypes.addAll(parameterContainerTypes);
            return (B)this;
        }

        public B setExistingConverters(Map<String, String> existingConverters) {
            this.existingConverters = existingConverters;
            return (B)this;
        }

        public B setScannedResourcePaths(Map<DotName, String> scannedResourcePaths) {
            this.scannedResourcePaths = scannedResourcePaths;
            return (B)this;
        }

        public B setFactoryCreator(Function<String, BeanFactory<Object>> factoryCreator) {
            this.factoryCreator = factoryCreator;
            return (B)this;
        }

        public B setConfig(ResteasyReactiveConfig config) {
            this.config = config;
            return (B)this;
        }

        public B setAdditionalReaders(AdditionalReaders additionalReaders) {
            this.additionalReaders = additionalReaders;
            return (B)this;
        }

        public B setHttpAnnotationToMethod(Map<DotName, String> httpAnnotationToMethod) {
            this.httpAnnotationToMethod = httpAnnotationToMethod;
            return (B)this;
        }

        public B setInjectableBeans(Map<String, InjectableBean> injectableBeans) {
            this.injectableBeans = injectableBeans;
            return (B)this;
        }

        public B setAdditionalWriters(AdditionalWriters additionalWriters) {
            this.additionalWriters = additionalWriters;
            return (B)this;
        }

        public B setClassLevelExceptionMappers(Map<DotName, Map<String, String>> classLevelExceptionMappers) {
            this.classLevelExceptionMappers = classLevelExceptionMappers;
            return (B)this;
        }

        public B setResourceMethodCallback(Consumer<ResourceMethodCallbackEntry> resourceMethodCallback) {
            this.resourceMethodCallback = resourceMethodCallback;
            return (B)this;
        }

        public B setAnnotationsTransformers(Collection<AnnotationsTransformer> annotationsTransformers) {
            this.annotationsTransformers = annotationsTransformers;
            return (B)this;
        }

        public B setApplicationScanningResult(ApplicationScanningResult applicationScanningResult) {
            this.applicationScanningResult = applicationScanningResult;
            return (B)this;
        }

        public B setTargetJavaVersion(TargetJavaVersion targetJavaVersion) {
            this.targetJavaVersion = targetJavaVersion;
            return (B)this;
        }

        public B setIsDisabledCreator(Function<ClassInfo, Supplier<Boolean>> isDisabledCreator) {
            this.isDisabledCreator = isDisabledCreator;
            return (B)this;
        }

        public B setSkipMethodParameter(Predicate<Map<DotName, AnnotationInstance>> skipMethodParameter) {
            this.skipMethodParameter = skipMethodParameter;
            return (B)this;
        }

        public abstract T build();
    }
}

