/**
 * Copyright 2016 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See
 * the License for the specific language governing permissions and limitations under the License.
 */

package io.reactivex;

/**
 * Interface to map/wrap a downstream observer to an upstream observer.
 */
public interface CompletableOperator {
    /**
     * Applies a function to the child CompletableObserver and returns a new parent CompletableObserver.
     * @param observer the child CompletableObservable instance
     * @return the parent CompletableObserver instance
     * @throws Exception on failure
     */
    CompletableObserver apply(CompletableObserver observer) throws Exception;
}
