/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.DeprecatedToNewConnectionFactoryFilter;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.transport.api.TransportObserver;
import java.util.Objects;
import javax.annotation.Nullable;

public class DelegatingConnectionFactory<ResolvedAddress, C extends ListenableAsyncCloseable>
implements ConnectionFactory<ResolvedAddress, C> {
    private final ConnectionFactory<ResolvedAddress, C> delegate;

    public DelegatingConnectionFactory(ConnectionFactory<ResolvedAddress, C> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    @Deprecated
    public Single<C> newConnection(ResolvedAddress resolvedAddress, @Nullable TransportObserver observer) {
        return this.delegate.newConnection(resolvedAddress, observer);
    }

    @Override
    public Single<C> newConnection(ResolvedAddress resolvedAddress, @Nullable ContextMap context, @Nullable TransportObserver observer) {
        return Single.defer(() -> {
            if (context != null) {
                AsyncContext.put(DeprecatedToNewConnectionFactoryFilter.CONNECTION_FACTORY_CONTEXT_MAP_KEY, context);
            }
            return this.newConnection(resolvedAddress, observer).shareContextOnSubscribe();
        });
    }

    @Override
    public Completable onClose() {
        return this.delegate.onClose();
    }

    @Override
    public Completable closeAsync() {
        return this.delegate.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.delegate.closeAsyncGracefully();
    }

    protected final ConnectionFactory<ResolvedAddress, C> delegate() {
        return this.delegate;
    }
}

