/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api;

import java.util.Locale;

public interface ServiceDiscovererEvent<ResolvedAddress> {
    public ResolvedAddress address();

    public Status status();

    public static final class Status {
        public static final Status AVAILABLE = new Status("available");
        public static final Status UNAVAILABLE = new Status("unavailable");
        public static final Status EXPIRED = new Status("expired");
        private final String name;

        private Status(String name) {
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Status name cannot be empty");
            }
            this.name = name.toLowerCase(Locale.ENGLISH);
        }

        public static Status of(String name) {
            switch (name.toLowerCase(Locale.ENGLISH)) {
                case "available": {
                    return AVAILABLE;
                }
                case "unavailable": {
                    return UNAVAILABLE;
                }
                case "expired": {
                    return EXPIRED;
                }
            }
            return new Status(name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Status)) {
                return false;
            }
            Status that = (Status)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

