/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CloseableIterator;
import io.servicetalk.concurrent.internal.AbstractCloseableIteratorAsInputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class CloseableIteratorAsInputStream<T>
extends AbstractCloseableIteratorAsInputStream<T> {
    private static final byte[] CLOSED = new byte[0];
    private final Function<? super T, byte[]> serializer;
    @Nullable
    private byte[] leftover;
    private int leftoverReadIndex;

    CloseableIteratorAsInputStream(CloseableIterator<T> source, Function<? super T, byte[]> serializer) {
        super(source);
        this.serializer = Objects.requireNonNull(serializer);
    }

    @Override
    protected int leftOverReadableBytes() {
        assert (this.leftover != null);
        return this.leftover.length - this.leftoverReadIndex;
    }

    @Override
    protected void leftOverReadBytes(byte[] dst, int offset, int length) {
        assert (this.leftover != null);
        System.arraycopy(this.leftover, this.leftoverReadIndex, dst, offset, length);
        this.leftoverReadIndex += length;
    }

    @Override
    protected boolean hasLeftOver() {
        return this.leftover != null;
    }

    @Override
    protected void leftOverCheckReset() {
        assert (this.leftover != null);
        if (this.leftoverReadIndex == this.leftover.length) {
            this.leftOverReset();
        }
    }

    @Override
    protected void leftOverReset() {
        this.leftover = null;
        this.leftoverReadIndex = 0;
    }

    @Override
    protected void nextLeftOver(CloseableIterator<T> iterator) {
        this.leftover = this.serializer.apply(iterator.next());
    }

    @Override
    protected byte leftOverReadSingleByte() {
        assert (this.leftover != null);
        byte value = this.leftover[this.leftoverReadIndex++];
        this.leftOverCheckReset();
        return value;
    }

    @Override
    protected boolean isClosed() {
        return this.leftover == CLOSED;
    }

    @Override
    public void close() throws IOException {
        this.leftover = CLOSED;
        super.close();
    }
}

