/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CompletionStageToSingle<T>
extends Single<T>
implements SingleSource<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletionStageToSingle.class);
    private final CompletionStage<? extends T> stage;

    CompletionStageToSingle(CompletionStage<? extends T> stage) {
        this.stage = Objects.requireNonNull(stage);
    }

    @Override
    protected void handleSubscribe(SingleSource.Subscriber<? super T> subscriber) {
        if (this.stage instanceof Future) {
            try {
                subscriber.onSubscribe(() -> ((Future)((Object)this.stage)).cancel(true));
            }
            catch (Throwable t) {
                SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, t);
                return;
            }
        }
        CompletableFuture future = this.toCompletableFuture();
        if (future != null) {
            try {
                subscriber.onSubscribe(() -> future.cancel(true));
            }
            catch (Throwable t) {
                SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, t);
                return;
            }
        }
        try {
            subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, t);
            return;
        }
        this.stage.whenComplete((value, cause) -> {
            try {
                if (cause != null) {
                    subscriber.onError((Throwable)cause);
                } else {
                    subscriber.onSuccess(value);
                }
            }
            catch (Throwable t) {
                LOGGER.info("Ignoring exception from terminal method of Subscriber {}.", (Object)subscriber, (Object)t);
            }
        });
    }

    @Nullable
    private CompletableFuture<? extends T> toCompletableFuture() {
        try {
            return this.stage.toCompletableFuture();
        }
        catch (Throwable cause) {
            return null;
        }
    }

    @Override
    public void subscribe(SingleSource.Subscriber<? super T> subscriber) {
        this.subscribeInternal(subscriber);
    }
}

