/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.ContextPreservingCallable;
import io.servicetalk.concurrent.api.DefaultAsyncContextProvider;
import io.servicetalk.context.api.ContextMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;

final class ContextAwareExecutorUtils {
    private ContextAwareExecutorUtils() {
    }

    static <X> Collection<? extends Callable<X>> wrap(Collection<? extends Callable<X>> tasks) {
        ArrayList<ContextPreservingCallable<X>> wrappedTasks = new ArrayList<ContextPreservingCallable<X>>(tasks.size());
        ContextMap contextMap = DefaultAsyncContextProvider.INSTANCE.context();
        for (Callable<X> task : tasks) {
            wrappedTasks.add(new ContextPreservingCallable<X>(task, contextMap));
        }
        return wrappedTasks;
    }
}

