/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import java.util.Objects;
import java.util.function.Consumer;

final class ContextPreservingConsumer<T>
implements Consumer<T> {
    private final ContextMap saved;
    private final Consumer<T> delegate;

    ContextPreservingConsumer(Consumer<T> delegate, ContextMap current) {
        this.saved = Objects.requireNonNull(current);
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(T t) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)((Object)currentThread);
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                this.delegate.accept(t);
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        } else {
            this.slowPath(t);
        }
    }

    private void slowPath(T t) {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            this.delegate.accept(t);
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }
}

