/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public final class DefaultThreadFactory
implements ThreadFactory {
    private static final AtomicInteger factoryCount = new AtomicInteger();
    public static final String DEFAULT_NAME_PREFIX = "servicetalk-executor";
    private final String namePrefix;
    private final boolean daemon;
    private final int priority;
    private final AtomicInteger threadCount = new AtomicInteger();

    public DefaultThreadFactory() {
        this(true);
    }

    public DefaultThreadFactory(boolean daemon) {
        this(daemon, 5);
    }

    public DefaultThreadFactory(int priority) {
        this(true, priority);
    }

    public DefaultThreadFactory(String namePrefix) {
        this(namePrefix, true, 5);
    }

    public DefaultThreadFactory(boolean daemon, int priority) {
        this(DEFAULT_NAME_PREFIX, daemon, priority);
    }

    public DefaultThreadFactory(String namePrefix, boolean daemon, int priority) {
        this.namePrefix = Objects.requireNonNull(namePrefix) + '-' + factoryCount.incrementAndGet() + '-';
        this.daemon = daemon;
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable r) {
        AsyncContextHolderThread t = new AsyncContextHolderThread(r, this.namePrefix + this.threadCount.incrementAndGet());
        if (t.isDaemon() != this.daemon) {
            t.setDaemon(this.daemon);
        }
        if (t.getPriority() != this.priority) {
            t.setPriority(this.priority);
        }
        return t;
    }

    public String toString() {
        return DefaultThreadFactory.class.getSimpleName() + "{namePrefix='" + this.namePrefix + '\'' + ", daemon=" + this.daemon + ", priority=" + this.priority + ", threadCount=" + this.threadCount + '}';
    }

    private static final class AsyncContextHolderThread
    extends Thread
    implements ContextMapHolder {
        @Nullable
        private ContextMap context;

        AsyncContextHolderThread(Runnable target, String name) {
            super(target, name);
        }

        @Override
        public AsyncContextHolderThread context(@Nullable ContextMap context) {
            this.context = context;
            return this;
        }

        @Override
        @Nullable
        public ContextMap context() {
            return this.context;
        }
    }
}

