/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Publisher;
import java.util.Objects;
import java.util.function.Function;

final class MapPublisher<R, T>
extends AbstractSynchronousPublisherOperator<T, R> {
    private final Function<? super T, ? extends R> mapper;

    MapPublisher(Publisher<T> source, Function<? super T, ? extends R> mapper) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super R> originalSubscriber) {
        return new MapSubscriber<T, R>(originalSubscriber, this.mapper);
    }

    private static final class MapSubscriber<T, R>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super R> subscriber;
        private final Function<T, R> mapper;

        MapSubscriber(PublisherSource.Subscriber<? super R> subscriber, Function<T, R> mapper) {
            this.subscriber = Objects.requireNonNull(subscriber);
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription s) {
            this.subscriber.onSubscribe(s);
        }

        @Override
        public void onNext(T t) {
            this.subscriber.onNext(this.mapper.apply(t));
        }

        @Override
        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

