/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractAsynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class PublisherConcatWithCompletable<T>
extends AbstractAsynchronousPublisherOperator<T, T> {
    private final Completable next;
    private final boolean propagateCancel;

    PublisherConcatWithCompletable(Publisher<T> original, Completable next, boolean propagateCancel) {
        super(original);
        this.next = Objects.requireNonNull(next);
        this.propagateCancel = propagateCancel;
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return this.propagateCancel ? new ConcatSubscriberCancel<T>(subscriber, this.next) : new ConcatSubscriber<T>(subscriber, this.next);
    }

    private static final class ConcatSubscriber<T>
    implements CompletableSource.Subscriber,
    PublisherSource.Subscriber<T>,
    PublisherSource.Subscription {
        private static final Cancellable CANCELLED = () -> {};
        private static final AtomicReferenceFieldUpdater<ConcatSubscriber, Cancellable> cancellableUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcatSubscriber.class, Cancellable.class, "cancellable");
        private final PublisherSource.Subscriber<? super T> target;
        private final Completable next;
        private boolean nextSubscribed;
        private volatile Cancellable cancellable = IGNORE_CANCEL;

        ConcatSubscriber(PublisherSource.Subscriber<? super T> target, Completable next) {
            this.target = target;
            this.next = next;
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription s) {
            this.cancellable = s;
            this.target.onSubscribe(this);
        }

        @Override
        public void onNext(T t) {
            this.target.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.target.onError(t);
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            Cancellable c;
            do {
                if ((c = this.cancellable) != CANCELLED) continue;
                cancellable.cancel();
                break;
            } while (!cancellableUpdater.compareAndSet(this, c, cancellable));
        }

        @Override
        public void onComplete() {
            if (this.nextSubscribed) {
                this.target.onComplete();
            } else {
                this.nextSubscribed = true;
                this.next.subscribeInternal(this);
            }
        }

        @Override
        public void request(long n) {
            Cancellable currCancellable = this.cancellable;
            if (currCancellable instanceof PublisherSource.Subscription) {
                ((PublisherSource.Subscription)currCancellable).request(n);
            }
        }

        @Override
        public void cancel() {
            cancellableUpdater.getAndSet(this, CANCELLED).cancel();
        }
    }

    private static final class ConcatSubscriberCancel<T>
    implements CompletableSource.Subscriber,
    PublisherSource.Subscriber<T>,
    PublisherSource.Subscription {
        private static final Cancellable TERMINAL = () -> {};
        private static final Cancellable CANCEL_COMPLETABLE = () -> {};
        private static final AtomicReferenceFieldUpdater<ConcatSubscriberCancel, Cancellable> cancellableUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcatSubscriberCancel.class, Cancellable.class, "cancellable");
        private final PublisherSource.Subscriber<? super T> target;
        private final Completable next;
        private volatile Cancellable cancellable = IGNORE_CANCEL;

        ConcatSubscriberCancel(PublisherSource.Subscriber<? super T> target, Completable next) {
            this.target = target;
            this.next = next;
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription s) {
            this.cancellable = new FirstSubscription(s);
            this.target.onSubscribe(this);
        }

        @Override
        public void onNext(T t) {
            this.target.onNext(t);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void onError(Throwable t) {
            block5: {
                do lbl-1000:
                // 3 sources

                {
                    block6: {
                        c = this.cancellable;
                        if (!ConcatSubscriberCancel.$assertionsDisabled && c == ConcatSubscriberCancel.IGNORE_CANCEL) {
                            throw new AssertionError();
                        }
                        if (!FirstSubscription.class.equals(c.getClass())) break block6;
                        if (!ConcatSubscriberCancel.cancellableUpdater.compareAndSet(this, c, ConcatSubscriberCancel.TERMINAL)) ** GOTO lbl-1000
                        try {
                            this.target.onError(t);
                            break block5;
                        }
                        finally {
                            this.next.subscribeInternal(this);
                        }
                    }
                    if (c == ConcatSubscriberCancel.TERMINAL) break block5;
                } while (!ConcatSubscriberCancel.cancellableUpdater.compareAndSet(this, c, ConcatSubscriberCancel.TERMINAL));
                this.target.onError(t);
            }
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            Cancellable c;
            do {
                if ((c = this.cancellable) != TERMINAL && c != CANCEL_COMPLETABLE) continue;
                cancellable.cancel();
                break;
            } while (!cancellableUpdater.compareAndSet(this, c, cancellable));
        }

        @Override
        public void onComplete() {
            block3: {
                while (true) {
                    Cancellable c = this.cancellable;
                    assert (c != IGNORE_CANCEL);
                    if (FirstSubscription.class.equals(c.getClass())) {
                        if (!cancellableUpdater.compareAndSet(this, c, IGNORE_CANCEL)) continue;
                        this.next.subscribeInternal(this);
                        break block3;
                    }
                    if (c == TERMINAL) break block3;
                    if (cancellableUpdater.compareAndSet(this, c, TERMINAL)) break;
                }
                this.target.onComplete();
            }
        }

        @Override
        public void request(long n) {
            Cancellable currCancellable = this.cancellable;
            if (FirstSubscription.class.equals(currCancellable.getClass())) {
                ((FirstSubscription)currCancellable).request(n);
            }
        }

        @Override
        public void cancel() {
            Cancellable c;
            while ((c = this.cancellable) != TERMINAL && c != CANCEL_COMPLETABLE) {
                boolean firstCancel = FirstSubscription.class.equals(c.getClass());
                if (!cancellableUpdater.compareAndSet(this, c, firstCancel ? TERMINAL : CANCEL_COMPLETABLE)) continue;
                try {
                    c.cancel();
                    break;
                }
                finally {
                    if (firstCancel) {
                        this.next.subscribeInternal(this);
                    }
                }
            }
        }

        private static final class FirstSubscription
        implements PublisherSource.Subscription {
            private final PublisherSource.Subscription subscription;

            private FirstSubscription(PublisherSource.Subscription subscription) {
                this.subscription = subscription;
            }

            @Override
            public void cancel() {
                this.subscription.cancel();
            }

            @Override
            public void request(long n) {
                this.subscription.request(n);
            }
        }
    }
}

