/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.CloseableIterable;
import io.servicetalk.concurrent.CloseableIterator;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractCloseableIterable<T>
implements CloseableIterable<T> {
    private final Iterable<T> original;

    public AbstractCloseableIterable(Iterable<T> original) {
        this.original = original;
    }

    @Override
    public CloseableIterator<T> iterator() {
        final Iterator<T> iterator = this.original.iterator();
        return new CloseableIterator<T>(){
            private boolean closed;

            @Override
            public void close() throws Exception {
                AbstractCloseableIterable.this.closeIterator(iterator);
            }

            @Override
            public boolean hasNext() {
                if (!iterator.hasNext()) {
                    if (!this.closed) {
                        this.closed = true;
                        try {
                            this.close();
                        }
                        catch (Exception e) {
                            PlatformDependent.throwException(e);
                        }
                    }
                    return false;
                }
                return true;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return iterator.next();
                }
                throw new NoSuchElementException();
            }
        };
    }

    protected abstract void closeIterator(Iterator<T> var1) throws Exception;
}

