/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.Cancellable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

public class DelayedCancellable
implements Cancellable {
    private static final AtomicReferenceFieldUpdater<DelayedCancellable, Cancellable> currentUpdater = AtomicReferenceFieldUpdater.newUpdater(DelayedCancellable.class, Cancellable.class, "current");
    @Nullable
    private volatile Cancellable current;

    public final void delayedCancellable(Cancellable delayedCancellable) {
        if (!currentUpdater.compareAndSet(this, null, Objects.requireNonNull(delayedCancellable))) {
            delayedCancellable.cancel();
        }
    }

    @Override
    public void cancel() {
        Cancellable oldCancellable = currentUpdater.getAndSet(this, IGNORE_CANCEL);
        if (oldCancellable != null) {
            oldCancellable.cancel();
        }
    }
}

