/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.Cancellable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public final class ThreadInterruptingCancellable
implements Cancellable {
    private static final AtomicIntegerFieldUpdater<ThreadInterruptingCancellable> statusUpdater = AtomicIntegerFieldUpdater.newUpdater(ThreadInterruptingCancellable.class, "status");
    private volatile int status;
    private final Thread threadToInterrupt;

    public ThreadInterruptingCancellable(Thread threadToInterrupt) {
        this.threadToInterrupt = Objects.requireNonNull(threadToInterrupt);
    }

    @Override
    public void cancel() {
        if (statusUpdater.compareAndSet(this, 0, 1)) {
            this.threadToInterrupt.interrupt();
        }
    }

    public void setDone() {
        this.status = 1;
    }

    public void setDone(Throwable cause) {
        this.setDone();
        if (cause instanceof InterruptedException) {
            Thread.interrupted();
        }
    }
}

