/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.encoding.api.BufferDecoder;
import io.servicetalk.encoding.api.BufferDecoderGroup;
import io.servicetalk.encoding.api.BufferEncoder;
import io.servicetalk.encoding.api.Identity;
import io.servicetalk.http.api.ContentEncodingHttpServiceFilter;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.UnsupportedContentEncodingException;
import java.util.Iterator;
import java.util.Objects;

public final class ContentEncodingHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory {
    private final BufferDecoderGroup decompressors;

    public ContentEncodingHttpRequesterFilter(BufferDecoderGroup decompressors) {
        this.decompressors = Objects.requireNonNull(decompressors);
    }

    @Override
    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            @Override
            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
                return ContentEncodingHttpRequesterFilter.this.applyEncodingAndDecoding(delegate, request);
            }
        };
    }

    @Override
    public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            @Override
            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                return ContentEncodingHttpRequesterFilter.this.applyEncodingAndDecoding(this.delegate(), request);
            }
        };
    }

    @Override
    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }

    private Single<StreamingHttpResponse> applyEncodingAndDecoding(StreamingHttpRequester delegate, StreamingHttpRequest request) {
        return Single.defer(() -> {
            StreamingHttpRequest encodedRequest;
            BufferEncoder encoder;
            boolean decompressResponse = false;
            CharSequence encodings = this.decompressors.advertisedMessageEncoding();
            if (encodings != null && !request.headers().contains(HttpHeaderNames.ACCEPT_ENCODING)) {
                request.headers().set(HttpHeaderNames.ACCEPT_ENCODING, encodings);
                decompressResponse = true;
            }
            if ((encoder = request.contentEncoding()) != null && !Identity.identityEncoder().equals(encoder)) {
                HeaderUtils.addContentEncoding(request.headers(), encoder.encodingName());
                request.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
                encodedRequest = request.transformPayloadBody(pub -> encoder.streamingEncoder().serialize((Publisher<Buffer>)pub, delegate.executionContext().bufferAllocator()));
            } else {
                encodedRequest = request;
            }
            Single<StreamingHttpResponse> respSingle = delegate.request(encodedRequest);
            return (decompressResponse ? respSingle.map(response -> {
                Iterator<? extends CharSequence> contentEncodingItr = response.headers().valuesIterator(HttpHeaderNames.CONTENT_ENCODING);
                boolean hasContentEncoding = contentEncodingItr.hasNext();
                if (!hasContentEncoding) {
                    return response;
                }
                BufferDecoder decoder = ContentEncodingHttpServiceFilter.matchAndRemoveEncoding(this.decompressors.decoders(), BufferDecoder::encodingName, contentEncodingItr, response.headers());
                if (decoder == null) {
                    throw new UnsupportedContentEncodingException(response.headers().get(HttpHeaderNames.CONTENT_ENCODING, "<null>").toString());
                }
                response.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
                return response.transformPayloadBody(pub -> decoder.streamingDecoder().deserialize((Publisher<Buffer>)pub, delegate.executionContext().bufferAllocator()));
            }) : respSingle).shareContextOnSubscribe();
        });
    }
}

