/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpSetCookie;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface HttpMetaData
extends ContextMapHolder {
    public HttpProtocolVersion version();

    public HttpMetaData version(HttpProtocolVersion var1);

    public HttpHeaders headers();

    @Deprecated
    default public HttpMetaData encoding(ContentCodec encoding) {
        throw new UnsupportedOperationException("HttpMetaData#encoding(ContentCodec) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to provided alternatives or implement this method if it's required temporarily.");
    }

    @Deprecated
    @Nullable
    default public ContentCodec encoding() {
        throw new UnsupportedOperationException("HttpMetaData#encoding() is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to provided alternatives or implement this method if it's required temporarily.");
    }

    default public HttpMetaData addHeader(CharSequence name, CharSequence value) {
        this.headers().add(name, value);
        return this;
    }

    default public HttpMetaData addHeaders(HttpHeaders headers) {
        this.headers().add(headers);
        return this;
    }

    default public HttpMetaData setHeader(CharSequence name, CharSequence value) {
        this.headers().set(name, value);
        return this;
    }

    default public HttpMetaData setHeaders(HttpHeaders headers) {
        this.headers().set(headers);
        return this;
    }

    default public HttpMetaData addCookie(HttpCookiePair cookie) {
        this.headers().addCookie(cookie);
        return this;
    }

    default public HttpMetaData addCookie(CharSequence name, CharSequence value) {
        this.headers().addCookie(name, value);
        return this;
    }

    default public HttpMetaData addSetCookie(HttpSetCookie cookie) {
        this.headers().addSetCookie(cookie);
        return this;
    }

    default public HttpMetaData addSetCookie(CharSequence name, CharSequence value) {
        this.headers().addSetCookie(name, value);
        return this;
    }

    public String toString();

    default public String toString(BiFunction<? super CharSequence, ? super CharSequence, CharSequence> headerFilter) {
        return this.toString() + System.lineSeparator() + this.headers().toString(headerFilter);
    }

    @Override
    @Nonnull
    public ContextMap context();

    @Override
    public HttpMetaData context(ContextMap var1);
}

