/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.servicetalk.http.api.Http2Settings;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.OptimizedHttp2FrameCodecBuilder;
import io.servicetalk.http.netty.ServiceTalkHttp2FrameLogger;
import io.servicetalk.logging.api.UserDataLoggerConfig;
import io.servicetalk.logging.slf4j.internal.Slf4jFixedLevelLoggers;
import javax.annotation.Nullable;

final class H2ServerParentChannelInitializer
implements io.servicetalk.transport.netty.internal.ChannelInitializer {
    private final H2ProtocolConfig config;
    private final ChannelInitializer<Http2StreamChannel> streamChannelInitializer;
    private final io.netty.handler.codec.http2.Http2Settings nettySettings;

    H2ServerParentChannelInitializer(H2ProtocolConfig config, ChannelInitializer<Http2StreamChannel> streamChannelInitializer) {
        this.config = config;
        this.streamChannelInitializer = streamChannelInitializer;
        Http2Settings h2Settings = config.initialSettings();
        this.nettySettings = H2ServerParentChannelInitializer.toNettySettings(h2Settings);
    }

    @Override
    public void init(Channel channel) {
        Http2FrameCodecBuilder multiplexCodecBuilder = new OptimizedHttp2FrameCodecBuilder(true, this.config.flowControlQuantum()).decoupleCloseAndGoAway(true).autoAckPingFrame(false).gracefulShutdownTimeoutMillis(-1L).initialSettings(this.nettySettings).validateHeaders(this.config.headersFactory().validateNames()).headerSensitivityDetector(this.config.headersSensitivityDetector()::test);
        H2ServerParentChannelInitializer.initFrameLogger(multiplexCodecBuilder, this.config.frameLoggerConfig());
        channel.pipeline().addLast(multiplexCodecBuilder.build(), new Http2MultiplexHandler(this.streamChannelInitializer));
        if (this.config.flowControlWindowIncrement() > 0) {
            channel.pipeline().addLast(new ChannelInboundHandlerAdapter(){

                @Override
                public void channelActive(ChannelHandlerContext ctx) {
                    ctx.write(new DefaultHttp2WindowUpdateFrame(H2ServerParentChannelInitializer.this.config.flowControlWindowIncrement()));
                    ctx.pipeline().remove(this);
                }
            });
        }
    }

    static void initFrameLogger(Http2FrameCodecBuilder multiplexCodecBuilder, @Nullable UserDataLoggerConfig frameLoggerConfig) {
        if (frameLoggerConfig != null) {
            multiplexCodecBuilder.frameLogger(new ServiceTalkHttp2FrameLogger(Slf4jFixedLevelLoggers.newLogger(frameLoggerConfig.loggerName(), frameLoggerConfig.logLevel()), frameLoggerConfig.logUserData()));
        }
    }

    static io.netty.handler.codec.http2.Http2Settings toNettySettings(Http2Settings h2Settings) {
        io.netty.handler.codec.http2.Http2Settings nettySettings = new io.netty.handler.codec.http2.Http2Settings();
        h2Settings.forEach((identifier, value) -> {
            switch (identifier.charValue()) {
                case '\u0001': {
                    nettySettings.headerTableSize((long)value);
                    break;
                }
                case '\u0002': {
                    nettySettings.pushEnabled(value != 0L);
                    break;
                }
                case '\u0003': {
                    nettySettings.maxConcurrentStreams((long)value);
                    break;
                }
                case '\u0004': {
                    nettySettings.initialWindowSize(value.intValue());
                    break;
                }
                case '\u0005': {
                    nettySettings.maxFrameSize(value.intValue());
                    break;
                }
                case '\u0006': {
                    nettySettings.maxHeaderListSize((long)value);
                    break;
                }
                default: {
                    nettySettings.put((Character)identifier, value);
                }
            }
        });
        return nettySettings;
    }
}

