/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.LoadBalancerFactory;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.DefaultThreadFactory;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancer;
import io.servicetalk.transport.api.ExecutionStrategy;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class RoundRobinLoadBalancerFactory<ResolvedAddress, C extends LoadBalancedConnection>
implements LoadBalancerFactory<ResolvedAddress, C> {
    private static final Duration DEFAULT_HEALTH_CHECK_INTERVAL = Duration.ofSeconds(5L);
    private static final Duration DEFAULT_HEALTH_CHECK_JITTER = Duration.ofSeconds(3L);
    static final int DEFAULT_HEALTH_CHECK_FAILED_CONNECTIONS_THRESHOLD = 5;
    private final int linearSearchSpace;
    @Nullable
    private final RoundRobinLoadBalancer.HealthCheckConfig healthCheckConfig;

    private RoundRobinLoadBalancerFactory(int linearSearchSpace, @Nullable RoundRobinLoadBalancer.HealthCheckConfig healthCheckConfig) {
        this.linearSearchSpace = linearSearchSpace;
        this.healthCheckConfig = healthCheckConfig;
    }

    @Override
    public <T extends C> LoadBalancer<T> newLoadBalancer(String targetResource, Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, T> connectionFactory) {
        return new RoundRobinLoadBalancer<ResolvedAddress, T>(Objects.requireNonNull(targetResource), eventPublisher, connectionFactory, this.linearSearchSpace, this.healthCheckConfig);
    }

    @Override
    public ExecutionStrategy requiredOffloads() {
        return ExecutionStrategy.offloadNone();
    }

    static final class SharedExecutor {
        private static final Executor INSTANCE = Executors.from(new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory("round-robin-load-balancer-executor")));

        private SharedExecutor() {
        }

        static Executor getInstance() {
            return INSTANCE;
        }
    }

    public static final class Builder<ResolvedAddress, C extends LoadBalancedConnection> {
        private int linearSearchSpace = 16;
        @Nullable
        private Executor backgroundExecutor;
        private Duration healthCheckInterval = RoundRobinLoadBalancerFactory.access$000();
        private Duration healthCheckJitter = RoundRobinLoadBalancerFactory.access$100();
        private int healthCheckFailedConnectionsThreshold = 5;

        public Builder<ResolvedAddress, C> linearSearchSpace(int linearSearchSpace) {
            if (linearSearchSpace < 0) {
                throw new IllegalArgumentException("linearSearchSpace: " + linearSearchSpace + " (expected >=0)");
            }
            this.linearSearchSpace = linearSearchSpace;
            return this;
        }

        public Builder<ResolvedAddress, C> backgroundExecutor(Executor backgroundExecutor) {
            this.backgroundExecutor = Objects.requireNonNull(backgroundExecutor);
            return this;
        }

        @Deprecated
        public Builder<ResolvedAddress, C> healthCheckInterval(Duration interval) {
            return this.healthCheckInterval(interval, interval.compareTo(DEFAULT_HEALTH_CHECK_INTERVAL) <= 0 ? interval.dividedBy(2L) : DEFAULT_HEALTH_CHECK_JITTER);
        }

        public Builder<ResolvedAddress, C> healthCheckInterval(Duration interval, Duration jitter) {
            if (interval.isNegative() || interval.isZero()) {
                throw new IllegalArgumentException("Health check interval should be greater than 0");
            }
            if (jitter.isNegative() || jitter.isZero()) {
                throw new IllegalArgumentException("Jitter interval should be greater than 0");
            }
            if (interval.minus(jitter).isNegative() || interval.plus(jitter).isNegative()) {
                throw new IllegalArgumentException("Jitter plus/minus interval underflow/overflow");
            }
            this.healthCheckInterval = interval;
            this.healthCheckJitter = jitter;
            return this;
        }

        public Builder<ResolvedAddress, C> healthCheckFailedConnectionsThreshold(int threshold) {
            if (threshold == 0) {
                throw new IllegalArgumentException("Health check failed connections threshold should not be 0");
            }
            this.healthCheckFailedConnectionsThreshold = threshold;
            return this;
        }

        public RoundRobinLoadBalancerFactory<ResolvedAddress, C> build() {
            if (this.healthCheckFailedConnectionsThreshold < 0) {
                return new RoundRobinLoadBalancerFactory(this.linearSearchSpace, null);
            }
            RoundRobinLoadBalancer.HealthCheckConfig healthCheckConfig = new RoundRobinLoadBalancer.HealthCheckConfig(this.backgroundExecutor == null ? SharedExecutor.getInstance() : this.backgroundExecutor, this.healthCheckInterval, this.healthCheckJitter, this.healthCheckFailedConnectionsThreshold);
            return new RoundRobinLoadBalancerFactory(this.linearSearchSpace, healthCheckConfig);
        }
    }
}

