/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.serializer.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.internal.ConnectablePayloadWriter;
import io.servicetalk.oio.api.PayloadWriter;
import io.servicetalk.serializer.api.SerializationException;
import io.servicetalk.serializer.api.StreamingSerializer;
import java.io.IOException;
import java.util.Objects;

final class StreamingSerializerUtils {
    private StreamingSerializerUtils() {
    }

    static <T> PayloadWriter<T> serialize(StreamingSerializer<T> serializer, final PayloadWriter<Buffer> writer, BufferAllocator allocator) {
        final ConnectablePayloadWriter connectablePayloadWriter = new ConnectablePayloadWriter();
        serializer.serialize(connectablePayloadWriter.connect(), allocator).forEach(buffer -> {
            try {
                writer.write(Objects.requireNonNull(buffer));
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        });
        return new PayloadWriter<T>(){

            @Override
            public void write(T t) throws IOException {
                connectablePayloadWriter.write(t);
            }

            @Override
            public void close(Throwable cause) throws IOException {
                try {
                    connectablePayloadWriter.close(cause);
                }
                finally {
                    writer.close(cause);
                }
            }

            @Override
            public void close() throws IOException {
                try {
                    connectablePayloadWriter.close();
                }
                finally {
                    writer.close();
                }
            }

            @Override
            public void flush() throws IOException {
                try {
                    connectablePayloadWriter.flush();
                }
                finally {
                    writer.flush();
                }
            }
        };
    }
}

