/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.util.DomainWildcardMappingBuilder;
import io.netty.util.Mapping;
import io.servicetalk.tcp.netty.internal.AbstractReadOnlyTcpConfig;
import io.servicetalk.tcp.netty.internal.TcpServerConfig;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.api.TransportObservers;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.transport.netty.internal.SslContextFactory;
import java.util.Map;
import javax.annotation.Nullable;

public final class ReadOnlyTcpServerConfig
extends AbstractReadOnlyTcpConfig<ServerSslConfig> {
    private final Map<ChannelOption, Object> listenOptions;
    private final TransportObserver transportObserver;
    @Nullable
    private final ServerSslConfig sslConfig;
    @Nullable
    private final SslContext sslContext;
    @Nullable
    private final Mapping<String, SslContext> sniMapping;
    private final boolean alpnConfigured;

    ReadOnlyTcpServerConfig(TcpServerConfig from) {
        super(from);
        this.listenOptions = ReadOnlyTcpServerConfig.nonNullOptions(from.listenOptions());
        TransportObserver transportObserver = from.transportObserver();
        this.transportObserver = transportObserver == NoopTransportObserver.INSTANCE ? transportObserver : TransportObservers.asSafeObserver(transportObserver);
        this.sslConfig = (ServerSslConfig)from.sslConfig();
        Map<String, ServerSslConfig> sniMap = from.sniConfig();
        if (sniMap != null) {
            if (this.sslConfig == null) {
                throw new IllegalStateException("No default security config defined but found SNI config mappings");
            }
            this.sslContext = SslContextFactory.forServer(this.sslConfig);
            boolean foundAlpn = !this.sslContext.applicationProtocolNegotiator().protocols().isEmpty();
            DomainWildcardMappingBuilder<SslContext> mappingBuilder = new DomainWildcardMappingBuilder<SslContext>(this.sslContext);
            for (Map.Entry<String, ServerSslConfig> sniConfigEntry : sniMap.entrySet()) {
                SslContext sniContext = SslContextFactory.forServer(sniConfigEntry.getValue());
                foundAlpn |= !sniContext.applicationProtocolNegotiator().protocols().isEmpty();
                mappingBuilder.add(sniConfigEntry.getKey(), sniContext);
            }
            this.sniMapping = mappingBuilder.build();
            this.alpnConfigured = foundAlpn;
        } else if (this.sslConfig != null) {
            this.sslContext = SslContextFactory.forServer(this.sslConfig);
            this.sniMapping = null;
            this.alpnConfigured = !this.sslContext.applicationProtocolNegotiator().protocols().isEmpty();
        } else {
            this.sslContext = null;
            this.sniMapping = null;
            this.alpnConfigured = false;
        }
    }

    public boolean isAlpnConfigured() {
        return this.alpnConfigured;
    }

    public TransportObserver transportObserver() {
        return this.transportObserver;
    }

    @Nullable
    public ServerSslConfig sslConfig() {
        return this.sslConfig;
    }

    @Override
    @Nullable
    public SslContext sslContext() {
        return this.sslContext;
    }

    @Nullable
    public Mapping<String, SslContext> sniMapping() {
        return this.sniMapping;
    }

    public Map<ChannelOption, Object> listenOptions() {
        return this.listenOptions;
    }
}

