/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslContext;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpClientConfig;
import io.servicetalk.tcp.netty.internal.TcpServerChannelInitializer;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.ConnectionObserverInitializer;
import io.servicetalk.transport.netty.internal.IdleTimeoutInitializer;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.transport.netty.internal.SslClientChannelInitializer;

public class TcpClientChannelInitializer
implements ChannelInitializer {
    private final ChannelInitializer delegate;

    public TcpClientChannelInitializer(ReadOnlyTcpClientConfig config, ConnectionObserver observer) {
        this(config, observer, false);
    }

    public TcpClientChannelInitializer(ReadOnlyTcpClientConfig config, ConnectionObserver observer, boolean deferSslHandler) {
        ChannelInitializer delegate = ChannelInitializer.defaultInitializer();
        SslContext sslContext = config.sslContext();
        if (observer != NoopTransportObserver.NoopConnectionObserver.INSTANCE) {
            delegate = delegate.andThen(new ConnectionObserverInitializer(observer, sslContext != null && !deferSslHandler, true));
        }
        if (config.idleTimeoutMs() > 0L) {
            delegate = delegate.andThen(new IdleTimeoutInitializer(config.idleTimeoutMs()));
        }
        if (sslContext != null) {
            ClientSslConfig sslConfig = config.sslConfig();
            assert (sslConfig != null);
            delegate = delegate.andThen(new SslClientChannelInitializer(sslContext, sslConfig, deferSslHandler));
        }
        this.delegate = TcpServerChannelInitializer.initWireLogger(delegate, config.wireLoggerConfig());
    }

    @Override
    public void init(Channel channel) {
        this.delegate.init(channel);
    }
}

