/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.SslConfig;
import io.servicetalk.transport.netty.internal.BuilderUtils;
import io.servicetalk.transport.netty.internal.SslUtils;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;

public final class SslContextFactory {
    private SslContextFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SslContext forClient(ClientSslConfig config) {
        SslContextBuilder builder = SslContextBuilder.forClient().sessionCacheSize(config.sessionCacheSize()).sessionTimeout(config.sessionTimeout());
        SslContextFactory.configureTrustManager(config, builder);
        KeyManagerFactory keyManagerFactory = config.keyManagerFactory();
        if (keyManagerFactory != null) {
            builder.keyManager(keyManagerFactory);
        } else {
            InputStream keyCertChainSupplier = null;
            InputStream keySupplier = null;
            try {
                keyCertChainSupplier = SslContextFactory.supplierNullSafe(config.keyCertChainSupplier());
                keySupplier = SslContextFactory.supplierNullSafe(config.keySupplier());
                builder.keyManager(keyCertChainSupplier, keySupplier, config.keyPassword());
            }
            catch (Throwable throwable) {
                try {
                    BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
                    throw throwable;
                }
                finally {
                    BuilderUtils.closeAndRethrowUnchecked(keySupplier);
                }
            }
            try {
                BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
            }
            finally {
                BuilderUtils.closeAndRethrowUnchecked(keySupplier);
            }
        }
        List<String> alpnProtocols = config.alpnProtocols();
        builder.sslProvider(SslUtils.toNettySslProvider(config.provider(), alpnProtocols != null && !alpnProtocols.isEmpty()));
        builder.protocols(config.sslProtocols());
        builder.ciphers(config.ciphers());
        builder.applicationProtocolConfig(SslUtils.nettyApplicationProtocol(alpnProtocols));
        try {
            return builder.build();
        }
        catch (SSLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SslContext forServer(ServerSslConfig config) {
        SslContextBuilder builder;
        KeyManagerFactory keyManagerFactory = config.keyManagerFactory();
        if (keyManagerFactory != null) {
            builder = SslContextBuilder.forServer(keyManagerFactory);
        } else {
            InputStream keyCertChainSupplier = null;
            InputStream keySupplier = null;
            try {
                keyCertChainSupplier = SslContextFactory.supplierNullSafe(config.keyCertChainSupplier());
                keySupplier = SslContextFactory.supplierNullSafe(config.keySupplier());
                builder = SslContextBuilder.forServer(keyCertChainSupplier, keySupplier, config.keyPassword());
            }
            catch (Throwable throwable) {
                try {
                    BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
                    throw throwable;
                }
                finally {
                    BuilderUtils.closeAndRethrowUnchecked(keySupplier);
                }
            }
            try {
                BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
            }
            finally {
                BuilderUtils.closeAndRethrowUnchecked(keySupplier);
            }
        }
        List<String> alpnProtocols = config.alpnProtocols();
        builder.sessionCacheSize(config.sessionCacheSize()).sessionTimeout(config.sessionTimeout()).applicationProtocolConfig(SslUtils.nettyApplicationProtocol(alpnProtocols));
        switch (config.clientAuthMode()) {
            case NONE: {
                builder.clientAuth(ClientAuth.NONE);
                break;
            }
            case OPTIONAL: {
                builder.clientAuth(ClientAuth.OPTIONAL);
                break;
            }
            case REQUIRE: {
                builder.clientAuth(ClientAuth.REQUIRE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported: " + (Object)((Object)config.clientAuthMode()));
            }
        }
        SslContextFactory.configureTrustManager(config, builder);
        builder.protocols(config.sslProtocols());
        builder.ciphers(config.ciphers());
        builder.sslProvider(SslUtils.toNettySslProvider(config.provider(), alpnProtocols != null && !alpnProtocols.isEmpty()));
        try {
            return builder.build();
        }
        catch (SSLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void configureTrustManager(SslConfig config, SslContextBuilder builder) {
        if (config.trustManagerFactory() != null) {
            builder.trustManager(config.trustManagerFactory());
        } else {
            InputStream trustManagerStream = SslContextFactory.supplierNullSafe(config.trustCertChainSupplier());
            try {
                builder.trustManager(trustManagerStream);
            }
            finally {
                BuilderUtils.closeAndRethrowUnchecked(trustManagerStream);
            }
        }
    }

    @Nullable
    private static <T> T supplierNullSafe(@Nullable Supplier<T> supplier) {
        return supplier == null ? null : (T)supplier.get();
    }
}

