/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues.ea.unpadded;

import org.jctools.queues.LinkedArrayQueueUtil;
import org.jctools.queues.ea.unpadded.MpscChunkedUnpaddedArrayQueue;
import org.jctools.util.Pow2;
import org.jctools.util.RangeUtil;

public class MpscGrowableUnpaddedArrayQueue<E>
extends MpscChunkedUnpaddedArrayQueue<E> {
    public MpscGrowableUnpaddedArrayQueue(int maxCapacity) {
        super(Math.max(2, Pow2.roundToPowerOfTwo(maxCapacity / 8)), maxCapacity);
    }

    public MpscGrowableUnpaddedArrayQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    @Override
    protected int getNextBufferSize(E[] buffer) {
        long maxSize = this.maxQueueCapacity / 2L;
        RangeUtil.checkLessThanOrEqual(LinkedArrayQueueUtil.length(buffer), maxSize, "buffer.length");
        int newSize = 2 * (LinkedArrayQueueUtil.length(buffer) - 1);
        return newSize + 1;
    }

    @Override
    protected long getCurrentBufferCapacity(long mask) {
        return mask + 2L == this.maxQueueCapacity ? this.maxQueueCapacity : mask;
    }
}

