/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.PerfSupport;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.BenchmarkResultMetaData;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ScalarResult;
import org.openjdk.jmh.util.HashMultiset;
import org.openjdk.jmh.util.Utils;

public class LinuxPerfNormProfiler
implements ExternalProfiler {
    private static final String[] interestingEvents = new String[]{"cycles", "instructions", "branches", "branch-misses", "L1-dcache-loads", "L1-dcache-load-misses", "L1-dcache-stores", "L1-dcache-store-misses", "L1-icache-loads", "L1-icache-load-misses", "LLC-loads", "LLC-load-misses", "LLC-stores", "LLC-store-misses", "dTLB-loads", "dTLB-load-misses", "dTLB-stores", "dTLB-store-misses", "iTLB-loads", "iTLB-load-misses", "stalled-cycles-frontend", "stalled-cycles-backend"};
    private final int delayMs;
    private final int lengthMs;
    private final boolean useDefaultStats;
    private final long highPassFilter;
    private final int incrementInterval;
    private final boolean isIncrementable;
    private final Collection<String> supportedEvents = new ArrayList<String>();

    public LinuxPerfNormProfiler(String initLine) throws ProfilerException {
        List<String> userEvents;
        OptionParser parser = new OptionParser();
        parser.formatHelpWith(new ProfilerOptionFormatter("perfnorm"));
        ArgumentAcceptingOptionSpec<String> optEvents = parser.accepts("events", "Events to gather.").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",").describedAs("event+");
        ArgumentAcceptingOptionSpec<Integer> optDelay = parser.accepts("delay", "Delay collection for a given time, in milliseconds; -1 to detect automatically.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo(-1, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> optLength = parser.accepts("length", "Do the collection for a given time, in milliseconds; -1 to detect automatically.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo(-1, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> optIncrementInterval = parser.accepts("interval", "The interval between incremental updates from a concurrently running perf. Lower values may improve accuracy, while increasing the profiling overhead.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo(100, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Long> optHighPassFilter = parser.accepts("highPassFilter", "Ignore event increments larger that this.").withRequiredArg().ofType(Long.class).describedAs("#").defaultsTo(100000000000L, (Long[])new Long[0]);
        ArgumentAcceptingOptionSpec<Boolean> optDefaultStat = parser.accepts("useDefaultStat", "Use \"perf stat -d -d -d\" instead of explicit counter list.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo(false, (Boolean[])new Boolean[0]);
        OptionSet set = ProfilerUtils.parseInitLine(initLine, parser);
        try {
            this.delayMs = set.valueOf(optDelay);
            this.lengthMs = set.valueOf(optLength);
            this.incrementInterval = set.valueOf(optIncrementInterval);
            this.highPassFilter = set.valueOf(optHighPassFilter);
            this.useDefaultStats = set.valueOf(optDefaultStat);
            userEvents = set.valuesOf(optEvents);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
        Collection<String> msgs = Utils.tryWith(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "echo", "1");
        if (!msgs.isEmpty()) {
            throw new ProfilerException(msgs.toString());
        }
        Collection<String> incremental = Utils.tryWith(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "--interval-print", String.valueOf(this.incrementInterval), "echo", "1");
        this.isIncrementable = incremental.isEmpty();
        if (userEvents != null) {
            for (String ev : userEvents) {
                if (ev.trim().isEmpty()) continue;
                this.supportedEvents.add(ev);
            }
        }
        if (this.supportedEvents.isEmpty()) {
            for (String ev : interestingEvents) {
                Collection<String> res = Utils.tryWith(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "--event", ev, "echo", "1");
                if (!res.isEmpty()) continue;
                this.supportedEvents.add(ev);
            }
        }
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.useDefaultStats) {
            cmd.addAll(Arrays.asList(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "--detailed", "--detailed", "--detailed"));
        } else {
            cmd.addAll(Arrays.asList(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "--event", Utils.join(this.supportedEvents, ",")));
        }
        if (this.isIncrementable) {
            cmd.addAll(Arrays.asList("-I", String.valueOf(this.incrementInterval)));
        }
        return cmd;
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        return this.process(br, stdOut, stdErr);
    }

    @Override
    public boolean allowPrintOut() {
        return true;
    }

    @Override
    public boolean allowPrintErr() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Linux perf statistics, normalized by operation count";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Collection<? extends Result> process(BenchmarkResult br, File stdOut, File stdErr) {
        HashMultiset<String> events = new HashMultiset<String>();
        try (FileReader fr = new FileReader(stdErr);){
            BufferedReader reader;
            block29: {
                ArrayList<PerfResult> arrayList;
                reader = new BufferedReader(fr);
                try {
                    BenchmarkResultMetaData md;
                    String line;
                    long skipMs = this.delayMs == -1 ? ProfilerUtils.measurementDelayMs(br) : (long)this.delayMs;
                    double lenMs = this.lengthMs == -1 ? (double)ProfilerUtils.measuredTimeMs(br) : (double)this.lengthMs;
                    double readFrom = (double)skipMs / 1000.0;
                    double softTo = ((double)skipMs + lenMs) / 1000.0;
                    double readTo = ((double)skipMs + lenMs + (double)this.incrementInterval) / 1000.0;
                    NumberFormat nf = NumberFormat.getInstance();
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("#")) continue;
                        if (this.isIncrementable) {
                            String event;
                            String count;
                            String time;
                            String[] split = line.split(",");
                            if (split.length == 3) {
                                time = split[0].trim();
                                count = split[1].trim();
                                event = split[2].trim();
                            } else {
                                if (split.length < 4) continue;
                                time = split[0].trim();
                                count = split[1].trim();
                                event = split[3].trim();
                            }
                            double multiplier = 1.0;
                            try {
                                double timeSec = nf.parse(time).doubleValue();
                                if (timeSec < readFrom || timeSec > readTo) continue;
                                double intervalSec = (double)this.incrementInterval / 1000.0;
                                if (timeSec - intervalSec < readFrom) {
                                    multiplier = (timeSec - readFrom) / intervalSec;
                                }
                                if (timeSec > softTo) {
                                    multiplier = 1.0 - (timeSec - softTo) / intervalSec;
                                }
                                multiplier = Math.max(1.0, Math.min(0.0, multiplier));
                            }
                            catch (ParseException e) {
                                continue;
                            }
                            try {
                                long lValue = nf.parse(count).longValue();
                                if (lValue > this.highPassFilter) continue;
                                events.add(event, (long)((double)lValue * multiplier));
                            }
                            catch (ParseException e) {}
                            continue;
                        }
                        int idx = line.lastIndexOf(",");
                        if (idx == -1) continue;
                        String count = line.substring(0, idx).trim();
                        String event = line.substring(idx + 1).trim();
                        try {
                            long lValue = nf.parse(count).longValue();
                            events.add(event, lValue);
                        }
                        catch (ParseException e) {}
                    }
                    if (!this.isIncrementable) {
                        System.out.println();
                        System.out.println();
                        System.out.println("WARNING: Your system uses old \"perf\", which cannot print data incrementally (-I).\nTherefore, perf performance data includes benchmark warmup.");
                    }
                    if ((md = br.getMetadata()) == null) break block29;
                    long totalOpts = this.isIncrementable ? md.getMeasurementOps() : md.getWarmupOps() + md.getMeasurementOps();
                    ArrayList<PerfResult> results = new ArrayList<PerfResult>();
                    for (String key : events.keys()) {
                        results.add(new PerfResult(key, "#/op", (double)events.count(key) * 1.0 / (double)totalOpts));
                    }
                    long cycles = events.count("cycles");
                    long instructions = events.count("instructions");
                    if (cycles != 0L && instructions != 0L) {
                        results.add(new PerfResult("CPI", "clks/insn", 1.0 * (double)cycles / (double)instructions));
                        results.add(new PerfResult("IPC", "insns/clk", 1.0 * (double)instructions / (double)cycles));
                    }
                    arrayList = results;
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                reader.close();
                return arrayList;
            }
            Set<PerfResult> set = Collections.singleton(new PerfResult("N/A", "", Double.NaN));
            reader.close();
            return set;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static class PerfResult
    extends ScalarResult {
        private static final long serialVersionUID = -1262685915873231436L;

        public PerfResult(String key, String unit, double value) {
            super(key, value, unit, AggregationPolicy.AVG);
        }

        @Override
        public String extendedInfo() {
            return "";
        }
    }
}

