/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.core.fallback.FallbackContext;
import io.smallrye.faulttolerance.core.invocation.Invoker;
import io.smallrye.faulttolerance.core.invocation.NormalMethodInvoker;
import io.smallrye.faulttolerance.core.invocation.SpecialMethodInvoker;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.util.Arrays;

public final class FallbackMethod {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final int exceptionParameterPosition;
    private final Method method;

    static FallbackMethod withoutExceptionParameter(Method method) {
        return method == null ? null : new FallbackMethod(method, -1);
    }

    static FallbackMethod withExceptionParameter(Method method, int exceptionParameterPosition) {
        return method == null ? null : new FallbackMethod(method, exceptionParameterPosition);
    }

    private FallbackMethod(Method method, int exceptionParameterPosition) {
        this.method = method;
        this.exceptionParameterPosition = exceptionParameterPosition;
    }

    public Invoker<?> createInvoker(FallbackContext<?> ctx) throws ReflectiveOperationException {
        InvocationContext interceptionContext = (InvocationContext)ctx.invocationContext.get(InvocationContext.class);
        Object[] arguments = interceptionContext.getParameters();
        if (arguments == null) {
            arguments = EMPTY_ARRAY;
        }
        arguments = this.adjustArguments(arguments, ctx.failure);
        return this.method.isDefault() ? new SpecialMethodInvoker(this.method, interceptionContext.getTarget(), arguments) : new NormalMethodInvoker(this.method, interceptionContext.getTarget(), arguments);
    }

    private Object[] adjustArguments(Object[] arguments, Throwable exception) {
        if (this.method.getParameterCount() == arguments.length) {
            return arguments;
        }
        if (this.method.getParameterCount() == arguments.length + 1) {
            Object[] argumentsWithException = new Object[arguments.length + 1];
            int exceptionParameterPosition = this.exceptionParameterPosition;
            for (int i = 0; i < arguments.length + 1; ++i) {
                argumentsWithException[i] = i < exceptionParameterPosition ? arguments[i] : (i == exceptionParameterPosition ? exception : arguments[i - 1]);
            }
            return argumentsWithException;
        }
        throw new IllegalArgumentException("Cannot adjust arguments " + Arrays.toString(arguments) + " to fallback method " + this.method);
    }
}

