/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server.transport;

import io.socket.engineio.server.Transport;
import io.socket.engineio.server.parser.Packet;
import io.socket.engineio.server.parser.Parser;
import io.socket.engineio.server.utils.JsonUtils;
import io.socket.engineio.server.utils.ParseQS;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Polling
extends Transport
implements AsyncListener {
    public static final String NAME = "polling";
    private static final List<Packet<?>> PACKET_CLOSE = Collections.unmodifiableList(new ArrayList<Packet<?>>(){
        {
            this.add(new Packet("close"));
        }
    });
    private static final List<Packet<?>> PACKET_NOOP = Collections.unmodifiableList(new ArrayList<Packet<?>>(){
        {
            this.add(new Packet("noop"));
        }
    });
    private final Object mLockObject;
    private HttpServletRequest mPollRequest;
    private HttpServletResponse mPollResponse;
    private boolean mWritable;
    private boolean mShouldClose;
    private Map<String, String> mQuery;
    private Map<String, List<String>> mHeaders;

    public Polling(Object lockObject, Parser parser) {
        super(parser);
        this.mLockObject = lockObject;
        this.mWritable = false;
        this.mShouldClose = false;
    }

    @Override
    public Map<String, String> getInitialQuery() {
        return this.mQuery;
    }

    @Override
    public Map<String, List<String>> getInitialHeaders() {
        return this.mHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Object object = this.mLockObject;
        synchronized (object) {
            if (this.mQuery == null) {
                this.mQuery = request.getQueryString() != null ? ParseQS.decode(request.getQueryString()) : new HashMap<String, String>();
            }
            if (this.mHeaders == null) {
                this.mHeaders = new HashMap<String, List<String>>();
                Enumeration iter = request.getHeaderNames();
                if (iter != null) {
                    while (iter.hasMoreElements()) {
                        String headerName = (String)iter.nextElement();
                        ArrayList<String> headerValues = new ArrayList<String>();
                        Enumeration iter2 = request.getHeaders(headerName);
                        while (iter2.hasMoreElements()) {
                            headerValues.add((String)iter2.nextElement());
                        }
                        this.mHeaders.put(headerName, headerValues);
                    }
                }
            }
            switch (request.getMethod().toLowerCase()) {
                case "get": {
                    this.onPollRequest(request, response);
                    break;
                }
                case "post": {
                    this.onDataRequest(request, response);
                    break;
                }
                default: {
                    response.setStatus(500);
                    response.getWriter().write("");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(List<Packet<?>> packets) {
        Object object = this.mLockObject;
        synchronized (object) {
            this.mWritable = false;
            if (this.mShouldClose) {
                packets.add(new Packet("close"));
            }
            Map query = (Map)this.mPollRequest.getAttribute("query");
            boolean jsonp = query.containsKey("j");
            if (packets.size() == 0) {
                throw new IllegalArgumentException("No packets to send.");
            }
            this.mParser.encodePayload(packets, true, data -> {
                byte[] contentBytes;
                String contentType;
                if (jsonp) {
                    String jsonpIndex = ((String)query.get("j")).replaceAll("[^0-9]", "");
                    String jsonContentString = data instanceof String ? "\"" + JsonUtils.escape((String)data) + "\"" : this.serializeByteArray((byte[])data);
                    String jsContentString = jsonContentString.replace("\u2028", "\\u2028").replace("\u2029", "\\u2029");
                    String contentString = "___eio[" + jsonpIndex + "](" + jsContentString + ")";
                    contentType = "text/javascript; charset=UTF-8";
                    contentBytes = contentString.getBytes(StandardCharsets.UTF_8);
                } else {
                    contentType = data instanceof String ? "text/plain; charset=UTF-8" : "application/octet-stream";
                    contentBytes = data instanceof String ? ((String)data).getBytes(StandardCharsets.UTF_8) : (byte[])data;
                }
                this.mPollResponse.setContentType(contentType);
                this.mPollResponse.setContentLength(contentBytes.length);
                try (ServletOutputStream outputStream = this.mPollResponse.getOutputStream();){
                    outputStream.write(contentBytes);
                }
                catch (IOException ex) {
                    this.onError("write failure", ex.getMessage());
                }
                if (this.mPollRequest.isAsyncStarted()) {
                    this.mPollRequest.getAsyncContext().complete();
                }
                this.mPollRequest = null;
                this.mPollResponse = null;
            });
            if (this.mShouldClose) {
                this.onClose();
            }
        }
    }

    @Override
    public boolean isWritable() {
        return this.mWritable;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        Object object = this.mLockObject;
        synchronized (object) {
            if (this.mWritable) {
                this.send(new ArrayList(PACKET_CLOSE));
                this.onClose();
            } else {
                this.mShouldClose = true;
            }
        }
    }

    @Override
    protected void onData(Object data) {
        this.mParser.decodePayload(data, (packet, index, total) -> {
            if (packet.type.equals("close")) {
                this.onClose();
                return false;
            }
            this.onPacket(packet);
            return true;
        });
    }

    @Override
    protected void onClose() {
        if (this.mWritable) {
            this.send(new ArrayList(PACKET_NOOP));
        }
        super.onClose();
    }

    public void onStartAsync(AsyncEvent asyncEvent) {
    }

    public void onComplete(AsyncEvent asyncEvent) {
    }

    public void onTimeout(AsyncEvent asyncEvent) {
        this.send(new ArrayList(PACKET_NOOP));
    }

    public void onError(AsyncEvent asyncEvent) {
        this.onError("async failure", null);
    }

    private void onPollRequest(HttpServletRequest request, HttpServletResponse response) {
        if (this.mPollRequest != null) {
            this.onError("overlap from client", "");
            this.mPollResponse.setStatus(500);
            try (PrintWriter writer2 = this.mPollResponse.getWriter();){
                writer2.print("error");
                writer2.flush();
            }
            catch (IOException writer2) {
                // empty catch block
            }
            return;
        }
        this.mPollRequest = request;
        this.mPollResponse = response;
        boolean asyncEnabled = false;
        if (request.isAsyncSupported() || request.isAsyncStarted()) {
            AsyncContext asyncContext = request.startAsync();
            asyncContext.addListener((AsyncListener)this);
            asyncContext.setTimeout(180000L);
            asyncEnabled = true;
        }
        this.mWritable = true;
        this.emit("drain", new Object[0]);
        if (this.mWritable && (!asyncEnabled || this.mShouldClose)) {
            this.send(new ArrayList(PACKET_NOOP));
        }
    }

    private void onDataRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map query = (Map)request.getAttribute("query");
        boolean jsonp = query.containsKey("j");
        byte[] readBuffer = this.readInput(request);
        if (jsonp) {
            String packetPayloadRaw = ParseQS.decode(new String(readBuffer, StandardCharsets.UTF_8)).get("d");
            String packetPayload = packetPayloadRaw.replace("\\n", "\n");
            this.onData(packetPayload);
        } else {
            this.onData(new String(readBuffer, StandardCharsets.UTF_8));
        }
        response.setContentType("text/html");
        response.getWriter().write("ok");
    }

    private String serializeByteArray(byte[] input) {
        CharSequence[] array = new String[input.length];
        for (int i = 0; i < input.length; ++i) {
            array[i] = Byte.toString(input[i]);
        }
        return '[' + String.join((CharSequence)",", array) + ']';
    }

    private byte[] readInput(HttpServletRequest request) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            byte[] readBuffer = new byte[request.getContentLength()];
            for (int remaining = readBuffer.length; remaining > 0; remaining -= inputStream.read(readBuffer, readBuffer.length - remaining, readBuffer.length)) {
            }
            byte[] byArray = readBuffer;
            return byArray;
        }
    }
}

