/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server.transport;

import io.socket.engineio.server.EngineIoWebSocket;
import io.socket.engineio.server.Transport;
import io.socket.engineio.server.parser.Packet;
import io.socket.engineio.server.parser.Parser;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WebSocket
extends Transport {
    public static final String NAME = "websocket";
    private final EngineIoWebSocket mConnection;

    public WebSocket(EngineIoWebSocket webSocket, Parser parser) {
        super(parser);
        this.mConnection = webSocket;
        this.mConnection.on("message", args -> this.onData(args[0]));
        this.mConnection.on("close", args -> this.onClose());
        this.mConnection.on("error", args -> this.onError((String)args[0], (String)args[1]));
    }

    @Override
    public Map<String, String> getInitialQuery() {
        return this.mConnection.getQuery();
    }

    @Override
    public Map<String, List<String>> getInitialHeaders() {
        return this.mConnection.getConnectionHeaders();
    }

    @Override
    public void onRequest(HttpServletRequest request, HttpServletResponse response) {
    }

    @Override
    public void send(List<Packet<?>> packets) {
        Parser.EncodeCallback<Object> encodeCallback = data -> {
            try {
                if (data instanceof String) {
                    this.mConnection.write((String)data);
                } else if (data instanceof byte[]) {
                    this.mConnection.write((byte[])data);
                }
            }
            catch (IOException ex) {
                this.onError("write error", ex.getMessage());
            }
        };
        for (Packet<?> packet : packets) {
            this.mParser.encodePacket(packet, true, encodeCallback);
        }
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void doClose() {
        this.mConnection.close();
    }
}

