/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.specto.hoverfly.junit.core.ObjectMapperFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;

class LoggingOutputStream
extends OutputStream {
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream(1000);
    private final Logger logger;
    private static final ObjectMapper LOG_PARSER = ObjectMapperFactory.getDefaultObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    LoggingOutputStream(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void write(int b) {
        if (b == 10) {
            String line = this.stream.toString();
            this.stream.reset();
            try {
                Map logLine = (Map)LOG_PARSER.readValue(line, Map.class);
                String message = String.valueOf(logLine.remove("msg"));
                String level = String.valueOf(logLine.remove("level"));
                logLine.remove("time");
                this.log(level, message, logLine);
            }
            catch (IOException e) {
                this.logger.info(line);
            }
        } else {
            this.stream.write(b);
        }
    }

    private void log(String level, String message, Map<?, ?> details) {
        switch (level) {
            case "panic": 
            case "fatal": 
            case "error": {
                this.logger.error("{} {}", (Object)message, (Object)new MapToString(details));
                break;
            }
            case "warning": {
                this.logger.warn("{} {}", (Object)message, (Object)new MapToString(details));
                break;
            }
            default: {
                this.logger.info("{} {}", (Object)message, (Object)new MapToString(details));
                break;
            }
            case "debug": {
                this.logger.debug("{} {}", (Object)message, (Object)new MapToString(details));
            }
        }
    }

    private static class MapToString {
        private final Map<?, ?> delegate;

        private MapToString(Map<?, ?> delegate) {
            this.delegate = delegate;
        }

        public String toString() {
            return this.delegate.isEmpty() ? "" : this.delegate.entrySet().stream().map(e -> e.getKey() + "=" + e.getValue()).collect(Collectors.joining(" "));
        }
    }
}

