/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.moniker.frigga;

import com.netflix.frigga.Names;
import com.netflix.frigga.autoscaling.AutoScalingGroupNameBuilder;
import com.netflix.spinnaker.moniker.Moniker;
import com.netflix.spinnaker.moniker.Namer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FriggaReflectiveNamer
implements Namer<Object> {
    @Override
    public Moniker deriveMoniker(Object obj) {
        String name = this.getName(obj);
        Names names = Names.parseName((String)name);
        return Moniker.builder().app(names.getApp()).stack(names.getStack()).detail(names.getDetail()).cluster(names.getCluster()).sequence(names.getSequence()).build();
    }

    @Override
    public void applyMoniker(Object obj, Moniker moniker) {
        AutoScalingGroupNameBuilder nameBuilder = new AutoScalingGroupNameBuilder();
        nameBuilder.withAppName(moniker.getApp());
        nameBuilder.withStack(moniker.getStack());
        nameBuilder.withDetail(moniker.getDetail());
        String name = nameBuilder.buildGroupName();
        if (moniker.getSequence() != null) {
            name = String.format("%s-v%03d", name, moniker.getSequence());
        }
        this.setName(obj, name);
    }

    private void setName(Object obj, String name) {
        Class<?> clazz;
        for (clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Method setName = clazz.getDeclaredMethod("setName", String.class);
                setName.setAccessible(true);
                setName.invoke(obj, name);
                return;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException setName) {
                continue;
            }
        }
        for (clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Field nameField = clazz.getDeclaredField("name");
                nameField.setAccessible(true);
                nameField.set(obj, name);
                return;
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                continue;
            }
        }
        throw new IllegalArgumentException("No way to infer how to name " + obj.getClass().getSimpleName());
    }

    private String getName(Object obj) {
        Class<?> clazz = obj.getClass();
        if (clazz == String.class) {
            return (String)obj;
        }
        while (clazz != Object.class) {
            try {
                Method setName = clazz.getDeclaredMethod("getName", new Class[0]);
                setName.setAccessible(true);
                return (String)setName.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException setName) {
                clazz = clazz.getSuperclass();
            }
        }
        for (clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Field nameField = clazz.getDeclaredField("name");
                nameField.setAccessible(true);
                return (String)nameField.get(obj);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                continue;
            }
        }
        throw new IllegalArgumentException("No way to infer how to name " + obj.getClass().getSimpleName());
    }
}

