/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.config;

import io.spring.javaformat.config.IndentationStyle;
import io.spring.javaformat.config.JavaBaseline;
import io.spring.javaformat.config.JavaFormatConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

class PropertiesJavaFormatConfig
implements JavaFormatConfig {
    private final Properties properties;

    PropertiesJavaFormatConfig(Properties properties) {
        this.properties = properties;
    }

    @Override
    public JavaBaseline getJavaBaseline() {
        Object value = this.properties.get("java-baseline");
        return value != null ? JavaBaseline.valueOf("V" + value.toString().toUpperCase().trim()) : DEFAULT.getJavaBaseline();
    }

    @Override
    public IndentationStyle getIndentationStyle() {
        Object value = this.properties.get("indentation-style");
        return value != null ? IndentationStyle.valueOf(value.toString().toUpperCase().trim()) : DEFAULT.getIndentationStyle();
    }

    static JavaFormatConfig load(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            JavaFormatConfig javaFormatConfig = PropertiesJavaFormatConfig.load(inputStream);
            return javaFormatConfig;
        }
    }

    static JavaFormatConfig load(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return new PropertiesJavaFormatConfig(properties);
    }
}

