/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.schema.AlternateTypeRuleConvention;
import springfox.documentation.schema.AlternateTypeRules;

public class JacksonSerializerConvention
implements AlternateTypeRuleConvention {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonSerializerConvention.class);
    private static final int IMMUTABLES_CONVENTION_ORDER = -2147479648;
    private final TypeResolver resolver;
    private final String packagePrefix;

    public JacksonSerializerConvention(TypeResolver resolver, String packagePrefix) {
        this.resolver = resolver;
        this.packagePrefix = packagePrefix;
    }

    public List<AlternateTypeRule> rules() {
        ArrayList rules = Lists.newArrayList();
        Reflections reflections = new Reflections(this.packagePrefix, new Scanner[0]);
        Set serialized = reflections.getTypesAnnotatedWith(JsonSerialize.class);
        Set deserialized = reflections.getTypesAnnotatedWith(JsonDeserialize.class);
        for (Class type : Sets.union((Set)serialized, (Set)deserialized)) {
            Optional<Type> found = this.findAlternate(type);
            if (!found.isPresent()) continue;
            rules.add(AlternateTypeRules.newRule((Type)this.resolver.resolve((Type)type, new Type[0]), (Type)this.resolver.resolve((Type)found.get(), new Type[0]), (int)this.getOrder()));
            rules.add(AlternateTypeRules.newRule((Type)this.resolver.resolve(ResponseEntity.class, new Type[]{type}), (Type)this.resolver.resolve((Type)found.get(), new Type[0]), (int)this.getOrder()));
        }
        return rules;
    }

    private Optional<Type> findAlternate(Class<?> type) {
        Class deserializer;
        Class serializer = (Class)Optional.fromNullable((Object)type.getAnnotation(JsonSerialize.class)).transform((Function)new Function<JsonSerialize, Class>(){

            public Class apply(JsonSerialize input) {
                return input.as();
            }
        }).or(Void.class);
        if (serializer != (deserializer = (Class)Optional.fromNullable((Object)type.getAnnotation(JsonDeserialize.class)).transform((Function)new Function<JsonDeserialize, Class>(){

            public Class apply(JsonDeserialize input) {
                return input.as();
            }
        }).or(Void.class))) {
            LOGGER.warn("The serializer {} and deserializer {} . Picking the serializer by default", (Object)serializer.getName(), (Object)deserializer.getName());
        }
        Class toUse = serializer == Void.class && deserializer == Void.class ? null : (serializer != Void.class ? serializer : deserializer);
        return Optional.fromNullable((Object)toUse);
    }

    public int getOrder() {
        return -2147479648;
    }
}

