/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.KafkaAuthorization;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Example;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.vertx.core.cli.annotations.DefaultValue;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "clientId", "tokenEndpointUri", "tlsTrustedCertificates", "disableTlsHostnameVerification", "delegateToKafkaAcls", "grantsRefreshPeriodSeconds", "grantsRefreshPoolSize", "superUsers"})
public class KafkaAuthorizationKeycloak
extends KafkaAuthorization {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_KEYCLOAK = "keycloak";
    public static final String AUTHORIZER_CLASS_NAME = "io.strimzi.kafka.oauth.server.authorizer.KeycloakRBACAuthorizer";
    private String clientId;
    private String tokenEndpointUri;
    private List<CertSecretSource> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification = false;
    private boolean delegateToKafkaAcls = false;
    private Integer grantsRefreshPeriodSeconds;
    private Integer grantsRefreshPoolSize;
    private List<String> superUsers;

    @Override
    @Description(value="Must be `keycloak`")
    public String getType() {
        return TYPE_KEYCLOAK;
    }

    @Override
    public boolean supportsAdminApi() {
        return this.delegateToKafkaAcls;
    }

    @Description(value="OAuth Client ID which the Kafka client can use to authenticate against the OAuth server and use the token endpoint URI.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Description(value="Authorization server token endpoint URI.")
    public String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public void setTokenEndpointUri(String tokenEndpointUri) {
        this.tokenEndpointUri = tokenEndpointUri;
    }

    @Description(value="Trusted certificates for TLS connection to the OAuth server.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CertSecretSource> getTlsTrustedCertificates() {
        return this.tlsTrustedCertificates;
    }

    public void setTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        this.tlsTrustedCertificates = tlsTrustedCertificates;
    }

    @Description(value="Enable or disable TLS hostname verification. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public void setDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification = disableTlsHostnameVerification;
    }

    @Description(value="Whether authorization decision should be delegated to the 'Simple' authorizer if DENIED by Keycloak Authorization Services policies. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isDelegateToKafkaAcls() {
        return this.delegateToKafkaAcls;
    }

    public void setDelegateToKafkaAcls(boolean delegateToKafkaAcls) {
        this.delegateToKafkaAcls = delegateToKafkaAcls;
    }

    @Description(value="The time between two consecutive grants refresh runs in seconds. The default value is 60.")
    @Minimum(value=0)
    @DefaultValue(value="60")
    public Integer getGrantsRefreshPeriodSeconds() {
        return this.grantsRefreshPeriodSeconds;
    }

    public void setGrantsRefreshPeriodSeconds(Integer grantsRefreshPeriodSeconds) {
        this.grantsRefreshPeriodSeconds = grantsRefreshPeriodSeconds;
    }

    @Description(value="The number of threads to use to refresh grants for active sessions. The more threads, the more parallelism, so the sooner the job completes. However, using more threads places a heavier load on the authorization server. The default value is 5.")
    @Minimum(value=1)
    @DefaultValue(value="5")
    public Integer getGrantsRefreshPoolSize() {
        return this.grantsRefreshPoolSize;
    }

    public void setGrantsRefreshPoolSize(Integer grantsRefreshPoolSize) {
        this.grantsRefreshPoolSize = grantsRefreshPoolSize;
    }

    @Description(value="List of super users. Should contain list of user principals which should get unlimited access rights.")
    @Example(value="- CN=my-user\n- CN=my-other-user")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getSuperUsers() {
        return this.superUsers;
    }

    public void setSuperUsers(List<String> superUsers) {
        this.superUsers = superUsers;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaAuthorizationKeycloak)) {
            return false;
        }
        KafkaAuthorizationKeycloak other = (KafkaAuthorizationKeycloak)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$tokenEndpointUri = this.getTokenEndpointUri();
        String other$tokenEndpointUri = other.getTokenEndpointUri();
        if (this$tokenEndpointUri == null ? other$tokenEndpointUri != null : !this$tokenEndpointUri.equals(other$tokenEndpointUri)) {
            return false;
        }
        List<CertSecretSource> this$tlsTrustedCertificates = this.getTlsTrustedCertificates();
        List<CertSecretSource> other$tlsTrustedCertificates = other.getTlsTrustedCertificates();
        if (this$tlsTrustedCertificates == null ? other$tlsTrustedCertificates != null : !((Object)this$tlsTrustedCertificates).equals(other$tlsTrustedCertificates)) {
            return false;
        }
        if (this.isDisableTlsHostnameVerification() != other.isDisableTlsHostnameVerification()) {
            return false;
        }
        if (this.isDelegateToKafkaAcls() != other.isDelegateToKafkaAcls()) {
            return false;
        }
        Integer this$grantsRefreshPeriodSeconds = this.getGrantsRefreshPeriodSeconds();
        Integer other$grantsRefreshPeriodSeconds = other.getGrantsRefreshPeriodSeconds();
        if (this$grantsRefreshPeriodSeconds == null ? other$grantsRefreshPeriodSeconds != null : !((Object)this$grantsRefreshPeriodSeconds).equals(other$grantsRefreshPeriodSeconds)) {
            return false;
        }
        Integer this$grantsRefreshPoolSize = this.getGrantsRefreshPoolSize();
        Integer other$grantsRefreshPoolSize = other.getGrantsRefreshPoolSize();
        if (this$grantsRefreshPoolSize == null ? other$grantsRefreshPoolSize != null : !((Object)this$grantsRefreshPoolSize).equals(other$grantsRefreshPoolSize)) {
            return false;
        }
        List<String> this$superUsers = this.getSuperUsers();
        List<String> other$superUsers = other.getSuperUsers();
        return !(this$superUsers == null ? other$superUsers != null : !((Object)this$superUsers).equals(other$superUsers));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaAuthorizationKeycloak;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $tokenEndpointUri = this.getTokenEndpointUri();
        result = result * 59 + ($tokenEndpointUri == null ? 43 : $tokenEndpointUri.hashCode());
        List<CertSecretSource> $tlsTrustedCertificates = this.getTlsTrustedCertificates();
        result = result * 59 + ($tlsTrustedCertificates == null ? 43 : ((Object)$tlsTrustedCertificates).hashCode());
        result = result * 59 + (this.isDisableTlsHostnameVerification() ? 79 : 97);
        result = result * 59 + (this.isDelegateToKafkaAcls() ? 79 : 97);
        Integer $grantsRefreshPeriodSeconds = this.getGrantsRefreshPeriodSeconds();
        result = result * 59 + ($grantsRefreshPeriodSeconds == null ? 43 : ((Object)$grantsRefreshPeriodSeconds).hashCode());
        Integer $grantsRefreshPoolSize = this.getGrantsRefreshPoolSize();
        result = result * 59 + ($grantsRefreshPoolSize == null ? 43 : ((Object)$grantsRefreshPoolSize).hashCode());
        List<String> $superUsers = this.getSuperUsers();
        result = result * 59 + ($superUsers == null ? 43 : ((Object)$superUsers).hashCode());
        return result;
    }
}

