/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.KafkaAuthorization;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.Example;
import java.util.List;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"type", "url", "allowOnError", "initialCacheCapacity", "maximumCacheSize", "expireAfterMs", "superUsers"})
public class KafkaAuthorizationOpa
extends KafkaAuthorization {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_OPA = "opa";
    public static final String AUTHORIZER_CLASS_NAME = "com.bisnode.kafka.authorization.OpaAuthorizer";
    private List<String> superUsers;
    private String url;
    private boolean allowOnError = false;
    private int initialCacheCapacity = 5000;
    private int maximumCacheSize = 50000;
    private long expireAfterMs = 3600000L;

    @Override
    @Description(value="Must be `opa`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return TYPE_OPA;
    }

    @Override
    public boolean supportsAdminApi() {
        return false;
    }

    @Description(value="List of super users, which is specifically a list of user principals that have unlimited access rights.")
    @Example(value="- CN=my-user\n- CN=my-other-user")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getSuperUsers() {
        return this.superUsers;
    }

    public void setSuperUsers(List<String> superUsers) {
        this.superUsers = superUsers;
    }

    @Description(value="The URL used to connect to the Open Policy Agent server. The URL has to include the policy which will be queried by the authorizer. This option is required.")
    @Example(value="http://opa:8181/v1/data/kafka/authz/allow")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Description(value="Defines whether a Kafka client should be allowed or denied by default when the authorizer fails to query the Open Policy Agent, for example, when it is temporarily unavailable). Defaults to `false` - all actions will be denied.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isAllowOnError() {
        return this.allowOnError;
    }

    public void setAllowOnError(boolean allowOnError) {
        this.allowOnError = allowOnError;
    }

    @Description(value="Initial capacity of the local cache used by the authorizer to avoid querying the Open Policy Agent for every request Defaults to `5000`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getInitialCacheCapacity() {
        return this.initialCacheCapacity;
    }

    public void setInitialCacheCapacity(int initialCacheCapacity) {
        this.initialCacheCapacity = initialCacheCapacity;
    }

    @Description(value="Maximum capacity of the local cache used by the authorizer to avoid querying the Open Policy Agent for every request. Defaults to `50000`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    @Description(value="The expiration of the records kept in the local cache to avoid querying the Open Policy Agent for every request. Defines how often the cached authorization decisions are reloaded from the Open Policy Agent server. In milliseconds. Defaults to `3600000`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public long getExpireAfterMs() {
        return this.expireAfterMs;
    }

    public void setExpireAfterMs(long expireAfterMs) {
        this.expireAfterMs = expireAfterMs;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaAuthorizationOpa)) {
            return false;
        }
        KafkaAuthorizationOpa other = (KafkaAuthorizationOpa)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$superUsers = this.getSuperUsers();
        List<String> other$superUsers = other.getSuperUsers();
        if (this$superUsers == null ? other$superUsers != null : !((Object)this$superUsers).equals(other$superUsers)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        if (this.isAllowOnError() != other.isAllowOnError()) {
            return false;
        }
        if (this.getInitialCacheCapacity() != other.getInitialCacheCapacity()) {
            return false;
        }
        if (this.getMaximumCacheSize() != other.getMaximumCacheSize()) {
            return false;
        }
        return this.getExpireAfterMs() == other.getExpireAfterMs();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaAuthorizationOpa;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $superUsers = this.getSuperUsers();
        result = result * 59 + ($superUsers == null ? 43 : ((Object)$superUsers).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        result = result * 59 + (this.isAllowOnError() ? 79 : 97);
        result = result * 59 + this.getInitialCacheCapacity();
        result = result * 59 + this.getMaximumCacheSize();
        long $expireAfterMs = this.getExpireAfterMs();
        result = result * 59 + (int)($expireAfterMs >>> 32 ^ $expireAfterMs);
        return result;
    }
}

