/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.KafkaBridgeHttpCors;
import io.strimzi.api.kafka.model.KafkaBridgeHttpCorsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaBridgeHttpCorsFluentImpl<A extends KafkaBridgeHttpCorsFluent<A>>
extends BaseFluent<A>
implements KafkaBridgeHttpCorsFluent<A> {
    private List<String> allowedOrigins;
    private List<String> allowedMethods;

    public KafkaBridgeHttpCorsFluentImpl() {
    }

    public KafkaBridgeHttpCorsFluentImpl(KafkaBridgeHttpCors instance) {
        this.withAllowedOrigins(instance.getAllowedOrigins());
        this.withAllowedMethods(instance.getAllowedMethods());
    }

    @Override
    public A addToAllowedOrigins(int index, String item) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>();
        }
        this.allowedOrigins.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedOrigins(int index, String item) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>();
        }
        this.allowedOrigins.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedOrigins(String ... items) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedOrigins.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedOrigins(Collection<String> items) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedOrigins.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedOrigins(String ... items) {
        for (String item : items) {
            if (this.allowedOrigins == null) continue;
            this.allowedOrigins.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedOrigins(Collection<String> items) {
        for (String item : items) {
            if (this.allowedOrigins == null) continue;
            this.allowedOrigins.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    @Override
    public String getAllowedOrigin(int index) {
        return this.allowedOrigins.get(index);
    }

    @Override
    public String getFirstAllowedOrigin() {
        return this.allowedOrigins.get(0);
    }

    @Override
    public String getLastAllowedOrigin() {
        return this.allowedOrigins.get(this.allowedOrigins.size() - 1);
    }

    @Override
    public String getMatchingAllowedOrigin(Predicate<String> predicate) {
        for (String item : this.allowedOrigins) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedOrigin(Predicate<String> predicate) {
        for (String item : this.allowedOrigins) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedOrigins(List<String> allowedOrigins) {
        if (this.allowedOrigins != null) {
            this._visitables.get((Object)"allowedOrigins").removeAll(this.allowedOrigins);
        }
        if (allowedOrigins != null) {
            this.allowedOrigins = new ArrayList<String>();
            for (String item : allowedOrigins) {
                this.addToAllowedOrigins(item);
            }
        } else {
            this.allowedOrigins = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedOrigins(String ... allowedOrigins) {
        if (this.allowedOrigins != null) {
            this.allowedOrigins.clear();
        }
        if (allowedOrigins != null) {
            for (String item : allowedOrigins) {
                this.addToAllowedOrigins(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedOrigins() {
        return this.allowedOrigins != null && !this.allowedOrigins.isEmpty();
    }

    @Override
    public A addNewAllowedOrigin(String original) {
        return this.addToAllowedOrigins(new String(original));
    }

    @Override
    public A addToAllowedMethods(int index, String item) {
        if (this.allowedMethods == null) {
            this.allowedMethods = new ArrayList<String>();
        }
        this.allowedMethods.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedMethods(int index, String item) {
        if (this.allowedMethods == null) {
            this.allowedMethods = new ArrayList<String>();
        }
        this.allowedMethods.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedMethods(String ... items) {
        if (this.allowedMethods == null) {
            this.allowedMethods = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedMethods.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedMethods(Collection<String> items) {
        if (this.allowedMethods == null) {
            this.allowedMethods = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedMethods.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedMethods(String ... items) {
        for (String item : items) {
            if (this.allowedMethods == null) continue;
            this.allowedMethods.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedMethods(Collection<String> items) {
        for (String item : items) {
            if (this.allowedMethods == null) continue;
            this.allowedMethods.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    @Override
    public String getAllowedMethod(int index) {
        return this.allowedMethods.get(index);
    }

    @Override
    public String getFirstAllowedMethod() {
        return this.allowedMethods.get(0);
    }

    @Override
    public String getLastAllowedMethod() {
        return this.allowedMethods.get(this.allowedMethods.size() - 1);
    }

    @Override
    public String getMatchingAllowedMethod(Predicate<String> predicate) {
        for (String item : this.allowedMethods) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedMethod(Predicate<String> predicate) {
        for (String item : this.allowedMethods) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedMethods(List<String> allowedMethods) {
        if (this.allowedMethods != null) {
            this._visitables.get((Object)"allowedMethods").removeAll(this.allowedMethods);
        }
        if (allowedMethods != null) {
            this.allowedMethods = new ArrayList<String>();
            for (String item : allowedMethods) {
                this.addToAllowedMethods(item);
            }
        } else {
            this.allowedMethods = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedMethods(String ... allowedMethods) {
        if (this.allowedMethods != null) {
            this.allowedMethods.clear();
        }
        if (allowedMethods != null) {
            for (String item : allowedMethods) {
                this.addToAllowedMethods(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedMethods() {
        return this.allowedMethods != null && !this.allowedMethods.isEmpty();
    }

    @Override
    public A addNewAllowedMethod(String original) {
        return this.addToAllowedMethods(new String(original));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaBridgeHttpCorsFluentImpl that = (KafkaBridgeHttpCorsFluentImpl)o;
        if (this.allowedOrigins != null ? !this.allowedOrigins.equals(that.allowedOrigins) : that.allowedOrigins != null) {
            return false;
        }
        return !(this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null);
    }

    public int hashCode() {
        return Objects.hash(this.allowedOrigins, this.allowedMethods, super.hashCode());
    }
}

