/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.ExternalLogging;
import io.strimzi.api.kafka.model.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.ExternalLoggingFluentImpl;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.InlineLoggingFluentImpl;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.JvmOptionsFluentImpl;
import io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpec;
import io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpecBuilder;
import io.strimzi.api.kafka.model.KafkaBridgeAdminClientSpecFluentImpl;
import io.strimzi.api.kafka.model.KafkaBridgeConsumerSpec;
import io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecBuilder;
import io.strimzi.api.kafka.model.KafkaBridgeConsumerSpecFluentImpl;
import io.strimzi.api.kafka.model.KafkaBridgeHttpConfig;
import io.strimzi.api.kafka.model.KafkaBridgeHttpConfigBuilder;
import io.strimzi.api.kafka.model.KafkaBridgeHttpConfigFluentImpl;
import io.strimzi.api.kafka.model.KafkaBridgeProducerSpec;
import io.strimzi.api.kafka.model.KafkaBridgeProducerSpecBuilder;
import io.strimzi.api.kafka.model.KafkaBridgeProducerSpecFluentImpl;
import io.strimzi.api.kafka.model.KafkaBridgeSpec;
import io.strimzi.api.kafka.model.KafkaBridgeSpecFluent;
import io.strimzi.api.kafka.model.KafkaBridgeTls;
import io.strimzi.api.kafka.model.KafkaBridgeTlsBuilder;
import io.strimzi.api.kafka.model.KafkaBridgeTlsFluentImpl;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeBuilder;
import io.strimzi.api.kafka.model.ProbeFluentImpl;
import io.strimzi.api.kafka.model.SpecFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplate;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl;
import io.strimzi.api.kafka.model.tracing.JaegerTracing;
import io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder;
import io.strimzi.api.kafka.model.tracing.JaegerTracingFluentImpl;
import io.strimzi.api.kafka.model.tracing.Tracing;
import java.util.Objects;

public class KafkaBridgeSpecFluentImpl<A extends KafkaBridgeSpecFluent<A>>
extends SpecFluentImpl<A>
implements KafkaBridgeSpecFluent<A> {
    private int replicas;
    private String image;
    private KafkaBridgeHttpConfigBuilder http;
    private String bootstrapServers;
    private KafkaBridgeTlsBuilder tls;
    private VisitableBuilder<? extends KafkaClientAuthentication, ?> authentication;
    private KafkaBridgeConsumerSpecBuilder consumer;
    private KafkaBridgeProducerSpecBuilder producer;
    private KafkaBridgeAdminClientSpecBuilder adminClient;
    private ResourceRequirements resources;
    private JvmOptionsBuilder jvmOptions;
    private VisitableBuilder<? extends Logging, ?> logging;
    private boolean enableMetrics;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private KafkaBridgeTemplateBuilder template;
    private VisitableBuilder<? extends Tracing, ?> tracing;

    public KafkaBridgeSpecFluentImpl() {
    }

    public KafkaBridgeSpecFluentImpl(KafkaBridgeSpec instance) {
        this.withReplicas(instance.getReplicas());
        this.withImage(instance.getImage());
        this.withHttp(instance.getHttp());
        this.withBootstrapServers(instance.getBootstrapServers());
        this.withTls(instance.getTls());
        this.withAuthentication(instance.getAuthentication());
        this.withConsumer(instance.getConsumer());
        this.withProducer(instance.getProducer());
        this.withAdminClient(instance.getAdminClient());
        this.withResources(instance.getResources());
        this.withJvmOptions(instance.getJvmOptions());
        this.withLogging(instance.getLogging());
        this.withEnableMetrics(instance.getEnableMetrics());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withTemplate(instance.getTemplate());
        this.withTracing(instance.getTracing());
    }

    @Override
    public int getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return true;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    @Deprecated
    public A withNewImage(String original) {
        return this.withImage(new String(original));
    }

    @Override
    @Deprecated
    public KafkaBridgeHttpConfig getHttp() {
        return this.http != null ? this.http.build() : null;
    }

    @Override
    public KafkaBridgeHttpConfig buildHttp() {
        return this.http != null ? this.http.build() : null;
    }

    @Override
    public A withHttp(KafkaBridgeHttpConfig http) {
        this._visitables.get((Object)"http").remove(this.http);
        if (http != null) {
            this.http = new KafkaBridgeHttpConfigBuilder(http);
            this._visitables.get((Object)"http").add(this.http);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttp() {
        return this.http != null;
    }

    @Override
    public A withNewHttp(int port) {
        return this.withHttp(new KafkaBridgeHttpConfig(port));
    }

    @Override
    public KafkaBridgeSpecFluent.HttpNested<A> withNewHttp() {
        return new HttpNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.HttpNested<A> withNewHttpLike(KafkaBridgeHttpConfig item) {
        return new HttpNestedImpl(item);
    }

    @Override
    public KafkaBridgeSpecFluent.HttpNested<A> editHttp() {
        return this.withNewHttpLike(this.getHttp());
    }

    @Override
    public KafkaBridgeSpecFluent.HttpNested<A> editOrNewHttp() {
        return this.withNewHttpLike(this.getHttp() != null ? this.getHttp() : new KafkaBridgeHttpConfigBuilder().build());
    }

    @Override
    public KafkaBridgeSpecFluent.HttpNested<A> editOrNewHttpLike(KafkaBridgeHttpConfig item) {
        return this.withNewHttpLike(this.getHttp() != null ? this.getHttp() : item);
    }

    @Override
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Override
    public A withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return (A)this;
    }

    @Override
    public Boolean hasBootstrapServers() {
        return this.bootstrapServers != null;
    }

    @Override
    @Deprecated
    public A withNewBootstrapServers(String original) {
        return this.withBootstrapServers(new String(original));
    }

    @Override
    @Deprecated
    public KafkaBridgeTls getTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public KafkaBridgeTls buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public A withTls(KafkaBridgeTls tls) {
        this._visitables.get((Object)"tls").remove(this.tls);
        if (tls != null) {
            this.tls = new KafkaBridgeTlsBuilder(tls);
            this._visitables.get((Object)"tls").add(this.tls);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return this.tls != null;
    }

    @Override
    public KafkaBridgeSpecFluent.TlsNested<A> withNewTls() {
        return new TlsNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.TlsNested<A> withNewTlsLike(KafkaBridgeTls item) {
        return new TlsNestedImpl(item);
    }

    @Override
    public KafkaBridgeSpecFluent.TlsNested<A> editTls() {
        return this.withNewTlsLike(this.getTls());
    }

    @Override
    public KafkaBridgeSpecFluent.TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : new KafkaBridgeTlsBuilder().build());
    }

    @Override
    public KafkaBridgeSpecFluent.TlsNested<A> editOrNewTlsLike(KafkaBridgeTls item) {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : item);
    }

    @Override
    @Deprecated
    public KafkaClientAuthentication getAuthentication() {
        return this.authentication != null ? (KafkaClientAuthentication)this.authentication.build() : null;
    }

    @Override
    public KafkaClientAuthentication buildAuthentication() {
        return this.authentication != null ? (KafkaClientAuthentication)this.authentication.build() : null;
    }

    @Override
    public A withAuthentication(KafkaClientAuthentication authentication) {
        if (authentication instanceof KafkaClientAuthenticationScramSha512) {
            this.authentication = new KafkaClientAuthenticationScramSha512Builder((KafkaClientAuthenticationScramSha512)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        if (authentication instanceof KafkaClientAuthenticationPlain) {
            this.authentication = new KafkaClientAuthenticationPlainBuilder((KafkaClientAuthenticationPlain)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        if (authentication instanceof KafkaClientAuthenticationOAuth) {
            this.authentication = new KafkaClientAuthenticationOAuthBuilder((KafkaClientAuthenticationOAuth)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        if (authentication instanceof KafkaClientAuthenticationTls) {
            this.authentication = new KafkaClientAuthenticationTlsBuilder((KafkaClientAuthenticationTls)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthentication() {
        return this.authentication != null;
    }

    @Override
    public A withKafkaClientAuthenticationScramSha512(KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationScramSha512 != null) {
            this.authentication = new KafkaClientAuthenticationScramSha512Builder(kafkaClientAuthenticationScramSha512);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512() {
        return new KafkaClientAuthenticationScramSha512NestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item) {
        return new KafkaClientAuthenticationScramSha512NestedImpl(item);
    }

    @Override
    public A withKafkaClientAuthenticationPlain(KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationPlain != null) {
            this.authentication = new KafkaClientAuthenticationPlainBuilder(kafkaClientAuthenticationPlain);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain() {
        return new KafkaClientAuthenticationPlainNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item) {
        return new KafkaClientAuthenticationPlainNestedImpl(item);
    }

    @Override
    public A withKafkaClientAuthenticationOAuth(KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationOAuth != null) {
            this.authentication = new KafkaClientAuthenticationOAuthBuilder(kafkaClientAuthenticationOAuth);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth() {
        return new KafkaClientAuthenticationOAuthNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item) {
        return new KafkaClientAuthenticationOAuthNestedImpl(item);
    }

    @Override
    public A withKafkaClientAuthenticationTls(KafkaClientAuthenticationTls kafkaClientAuthenticationTls) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationTls != null) {
            this.authentication = new KafkaClientAuthenticationTlsBuilder(kafkaClientAuthenticationTls);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls() {
        return new KafkaClientAuthenticationTlsNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item) {
        return new KafkaClientAuthenticationTlsNestedImpl(item);
    }

    @Override
    @Deprecated
    public KafkaBridgeConsumerSpec getConsumer() {
        return this.consumer != null ? this.consumer.build() : null;
    }

    @Override
    public KafkaBridgeConsumerSpec buildConsumer() {
        return this.consumer != null ? this.consumer.build() : null;
    }

    @Override
    public A withConsumer(KafkaBridgeConsumerSpec consumer) {
        this._visitables.get((Object)"consumer").remove(this.consumer);
        if (consumer != null) {
            this.consumer = new KafkaBridgeConsumerSpecBuilder(consumer);
            this._visitables.get((Object)"consumer").add(this.consumer);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConsumer() {
        return this.consumer != null;
    }

    @Override
    public KafkaBridgeSpecFluent.ConsumerNested<A> withNewConsumer() {
        return new ConsumerNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.ConsumerNested<A> withNewConsumerLike(KafkaBridgeConsumerSpec item) {
        return new ConsumerNestedImpl(item);
    }

    @Override
    public KafkaBridgeSpecFluent.ConsumerNested<A> editConsumer() {
        return this.withNewConsumerLike(this.getConsumer());
    }

    @Override
    public KafkaBridgeSpecFluent.ConsumerNested<A> editOrNewConsumer() {
        return this.withNewConsumerLike(this.getConsumer() != null ? this.getConsumer() : new KafkaBridgeConsumerSpecBuilder().build());
    }

    @Override
    public KafkaBridgeSpecFluent.ConsumerNested<A> editOrNewConsumerLike(KafkaBridgeConsumerSpec item) {
        return this.withNewConsumerLike(this.getConsumer() != null ? this.getConsumer() : item);
    }

    @Override
    @Deprecated
    public KafkaBridgeProducerSpec getProducer() {
        return this.producer != null ? this.producer.build() : null;
    }

    @Override
    public KafkaBridgeProducerSpec buildProducer() {
        return this.producer != null ? this.producer.build() : null;
    }

    @Override
    public A withProducer(KafkaBridgeProducerSpec producer) {
        this._visitables.get((Object)"producer").remove(this.producer);
        if (producer != null) {
            this.producer = new KafkaBridgeProducerSpecBuilder(producer);
            this._visitables.get((Object)"producer").add(this.producer);
        }
        return (A)this;
    }

    @Override
    public Boolean hasProducer() {
        return this.producer != null;
    }

    @Override
    public KafkaBridgeSpecFluent.ProducerNested<A> withNewProducer() {
        return new ProducerNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.ProducerNested<A> withNewProducerLike(KafkaBridgeProducerSpec item) {
        return new ProducerNestedImpl(item);
    }

    @Override
    public KafkaBridgeSpecFluent.ProducerNested<A> editProducer() {
        return this.withNewProducerLike(this.getProducer());
    }

    @Override
    public KafkaBridgeSpecFluent.ProducerNested<A> editOrNewProducer() {
        return this.withNewProducerLike(this.getProducer() != null ? this.getProducer() : new KafkaBridgeProducerSpecBuilder().build());
    }

    @Override
    public KafkaBridgeSpecFluent.ProducerNested<A> editOrNewProducerLike(KafkaBridgeProducerSpec item) {
        return this.withNewProducerLike(this.getProducer() != null ? this.getProducer() : item);
    }

    @Override
    @Deprecated
    public KafkaBridgeAdminClientSpec getAdminClient() {
        return this.adminClient != null ? this.adminClient.build() : null;
    }

    @Override
    public KafkaBridgeAdminClientSpec buildAdminClient() {
        return this.adminClient != null ? this.adminClient.build() : null;
    }

    @Override
    public A withAdminClient(KafkaBridgeAdminClientSpec adminClient) {
        this._visitables.get((Object)"adminClient").remove(this.adminClient);
        if (adminClient != null) {
            this.adminClient = new KafkaBridgeAdminClientSpecBuilder(adminClient);
            this._visitables.get((Object)"adminClient").add(this.adminClient);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdminClient() {
        return this.adminClient != null;
    }

    @Override
    public KafkaBridgeSpecFluent.AdminClientNested<A> withNewAdminClient() {
        return new AdminClientNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.AdminClientNested<A> withNewAdminClientLike(KafkaBridgeAdminClientSpec item) {
        return new AdminClientNestedImpl(item);
    }

    @Override
    public KafkaBridgeSpecFluent.AdminClientNested<A> editAdminClient() {
        return this.withNewAdminClientLike(this.getAdminClient());
    }

    @Override
    public KafkaBridgeSpecFluent.AdminClientNested<A> editOrNewAdminClient() {
        return this.withNewAdminClientLike(this.getAdminClient() != null ? this.getAdminClient() : new KafkaBridgeAdminClientSpecBuilder().build());
    }

    @Override
    public KafkaBridgeSpecFluent.AdminClientNested<A> editOrNewAdminClientLike(KafkaBridgeAdminClientSpec item) {
        return this.withNewAdminClientLike(this.getAdminClient() != null ? this.getAdminClient() : item);
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    @Deprecated
    public JvmOptions getJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.get((Object)"jvmOptions").remove(this.jvmOptions);
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.get((Object)"jvmOptions").add(this.jvmOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    @Override
    public KafkaBridgeSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNestedImpl(item);
    }

    @Override
    public KafkaBridgeSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions());
    }

    @Override
    public KafkaBridgeSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : new JvmOptionsBuilder().build());
    }

    @Override
    public KafkaBridgeSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : item);
    }

    @Override
    @Deprecated
    public Logging getLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public A withLogging(Logging logging) {
        if (logging instanceof ExternalLogging) {
            this.logging = new ExternalLoggingBuilder((ExternalLogging)logging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        if (logging instanceof InlineLogging) {
            this.logging = new InlineLoggingBuilder((InlineLogging)logging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLogging() {
        return this.logging != null;
    }

    @Override
    public A withExternalLogging(ExternalLogging externalLogging) {
        this._visitables.get((Object)"logging").remove(this.logging);
        if (externalLogging != null) {
            this.logging = new ExternalLoggingBuilder(externalLogging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public KafkaBridgeSpecFluent.ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNestedImpl(item);
    }

    @Override
    public A withInlineLogging(InlineLogging inlineLogging) {
        this._visitables.get((Object)"logging").remove(this.logging);
        if (inlineLogging != null) {
            this.logging = new InlineLoggingBuilder(inlineLogging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public KafkaBridgeSpecFluent.InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNestedImpl(item);
    }

    @Override
    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    @Override
    public A withEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
        return (A)this;
    }

    @Override
    public Boolean hasEnableMetrics() {
        return true;
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public KafkaBridgeSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public KafkaBridgeSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public KafkaBridgeSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public KafkaBridgeSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    @Deprecated
    public KafkaBridgeTemplate getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public KafkaBridgeTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(KafkaBridgeTemplate template) {
        this._visitables.get((Object)"template").remove(this.template);
        if (template != null) {
            this.template = new KafkaBridgeTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public KafkaBridgeSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.TemplateNested<A> withNewTemplateLike(KafkaBridgeTemplate item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public KafkaBridgeSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public KafkaBridgeSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new KafkaBridgeTemplateBuilder().build());
    }

    @Override
    public KafkaBridgeSpecFluent.TemplateNested<A> editOrNewTemplateLike(KafkaBridgeTemplate item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    @Deprecated
    public Tracing getTracing() {
        return this.tracing != null ? (Tracing)this.tracing.build() : null;
    }

    @Override
    public Tracing buildTracing() {
        return this.tracing != null ? (Tracing)this.tracing.build() : null;
    }

    @Override
    public A withTracing(Tracing tracing) {
        if (tracing instanceof JaegerTracing) {
            this.tracing = new JaegerTracingBuilder((JaegerTracing)tracing);
            this._visitables.get((Object)"tracing").add(this.tracing);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTracing() {
        return this.tracing != null;
    }

    @Override
    public A withJaegerTracing(JaegerTracing jaegerTracing) {
        this._visitables.get((Object)"tracing").remove(this.tracing);
        if (jaegerTracing != null) {
            this.tracing = new JaegerTracingBuilder(jaegerTracing);
            this._visitables.get((Object)"tracing").add(this.tracing);
        }
        return (A)this;
    }

    @Override
    public KafkaBridgeSpecFluent.JaegerTracingNested<A> withNewJaegerTracing() {
        return new JaegerTracingNestedImpl();
    }

    @Override
    public KafkaBridgeSpecFluent.JaegerTracingNested<A> withNewJaegerTracingLike(JaegerTracing item) {
        return new JaegerTracingNestedImpl(item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaBridgeSpecFluentImpl that = (KafkaBridgeSpecFluentImpl)o;
        if (this.replicas != that.replicas) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.http != null ? !this.http.equals(that.http) : that.http != null) {
            return false;
        }
        if (this.bootstrapServers != null ? !this.bootstrapServers.equals(that.bootstrapServers) : that.bootstrapServers != null) {
            return false;
        }
        if (this.tls != null ? !this.tls.equals(that.tls) : that.tls != null) {
            return false;
        }
        if (this.authentication != null ? !this.authentication.equals(that.authentication) : that.authentication != null) {
            return false;
        }
        if (this.consumer != null ? !this.consumer.equals(that.consumer) : that.consumer != null) {
            return false;
        }
        if (this.producer != null ? !this.producer.equals(that.producer) : that.producer != null) {
            return false;
        }
        if (this.adminClient != null ? !this.adminClient.equals(that.adminClient) : that.adminClient != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals((Object)that.resources) : that.resources != null) {
            return false;
        }
        if (this.jvmOptions != null ? !this.jvmOptions.equals(that.jvmOptions) : that.jvmOptions != null) {
            return false;
        }
        if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) {
            return false;
        }
        if (this.enableMetrics != that.enableMetrics) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        return !(this.tracing != null ? !this.tracing.equals(that.tracing) : that.tracing != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.replicas, this.image, this.http, this.bootstrapServers, this.tls, this.authentication, this.consumer, this.producer, this.adminClient, this.resources, this.jvmOptions, this.logging, this.enableMetrics, this.livenessProbe, this.readinessProbe, this.template, this.tracing, super.hashCode());
    }

    public class JaegerTracingNestedImpl<N>
    extends JaegerTracingFluentImpl<KafkaBridgeSpecFluent.JaegerTracingNested<N>>
    implements KafkaBridgeSpecFluent.JaegerTracingNested<N>,
    Nested<N> {
        private final JaegerTracingBuilder builder;

        JaegerTracingNestedImpl(JaegerTracing item) {
            this.builder = new JaegerTracingBuilder(this, item);
        }

        JaegerTracingNestedImpl() {
            this.builder = new JaegerTracingBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withTracing(this.builder.build());
        }

        @Override
        public N endJaegerTracing() {
            return this.and();
        }
    }

    public class TemplateNestedImpl<N>
    extends KafkaBridgeTemplateFluentImpl<KafkaBridgeSpecFluent.TemplateNested<N>>
    implements KafkaBridgeSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final KafkaBridgeTemplateBuilder builder;

        TemplateNestedImpl(KafkaBridgeTemplate item) {
            this.builder = new KafkaBridgeTemplateBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new KafkaBridgeTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<KafkaBridgeSpecFluent.ReadinessProbeNested<N>>
    implements KafkaBridgeSpecFluent.ReadinessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<KafkaBridgeSpecFluent.LivenessProbeNested<N>>
    implements KafkaBridgeSpecFluent.LivenessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class InlineLoggingNestedImpl<N>
    extends InlineLoggingFluentImpl<KafkaBridgeSpecFluent.InlineLoggingNested<N>>
    implements KafkaBridgeSpecFluent.InlineLoggingNested<N>,
    Nested<N> {
        private final InlineLoggingBuilder builder;

        InlineLoggingNestedImpl(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        InlineLoggingNestedImpl() {
            this.builder = new InlineLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withLogging(this.builder.build());
        }

        @Override
        public N endInlineLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingNestedImpl<N>
    extends ExternalLoggingFluentImpl<KafkaBridgeSpecFluent.ExternalLoggingNested<N>>
    implements KafkaBridgeSpecFluent.ExternalLoggingNested<N>,
    Nested<N> {
        private final ExternalLoggingBuilder builder;

        ExternalLoggingNestedImpl(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        ExternalLoggingNestedImpl() {
            this.builder = new ExternalLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withLogging(this.builder.build());
        }

        @Override
        public N endExternalLogging() {
            return this.and();
        }
    }

    public class JvmOptionsNestedImpl<N>
    extends JvmOptionsFluentImpl<KafkaBridgeSpecFluent.JvmOptionsNested<N>>
    implements KafkaBridgeSpecFluent.JvmOptionsNested<N>,
    Nested<N> {
        private final JvmOptionsBuilder builder;

        JvmOptionsNestedImpl(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        JvmOptionsNestedImpl() {
            this.builder = new JvmOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withJvmOptions(this.builder.build());
        }

        @Override
        public N endJvmOptions() {
            return this.and();
        }
    }

    public class AdminClientNestedImpl<N>
    extends KafkaBridgeAdminClientSpecFluentImpl<KafkaBridgeSpecFluent.AdminClientNested<N>>
    implements KafkaBridgeSpecFluent.AdminClientNested<N>,
    Nested<N> {
        private final KafkaBridgeAdminClientSpecBuilder builder;

        AdminClientNestedImpl(KafkaBridgeAdminClientSpec item) {
            this.builder = new KafkaBridgeAdminClientSpecBuilder(this, item);
        }

        AdminClientNestedImpl() {
            this.builder = new KafkaBridgeAdminClientSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withAdminClient(this.builder.build());
        }

        @Override
        public N endAdminClient() {
            return this.and();
        }
    }

    public class ProducerNestedImpl<N>
    extends KafkaBridgeProducerSpecFluentImpl<KafkaBridgeSpecFluent.ProducerNested<N>>
    implements KafkaBridgeSpecFluent.ProducerNested<N>,
    Nested<N> {
        private final KafkaBridgeProducerSpecBuilder builder;

        ProducerNestedImpl(KafkaBridgeProducerSpec item) {
            this.builder = new KafkaBridgeProducerSpecBuilder(this, item);
        }

        ProducerNestedImpl() {
            this.builder = new KafkaBridgeProducerSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withProducer(this.builder.build());
        }

        @Override
        public N endProducer() {
            return this.and();
        }
    }

    public class ConsumerNestedImpl<N>
    extends KafkaBridgeConsumerSpecFluentImpl<KafkaBridgeSpecFluent.ConsumerNested<N>>
    implements KafkaBridgeSpecFluent.ConsumerNested<N>,
    Nested<N> {
        private final KafkaBridgeConsumerSpecBuilder builder;

        ConsumerNestedImpl(KafkaBridgeConsumerSpec item) {
            this.builder = new KafkaBridgeConsumerSpecBuilder(this, item);
        }

        ConsumerNestedImpl() {
            this.builder = new KafkaBridgeConsumerSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withConsumer(this.builder.build());
        }

        @Override
        public N endConsumer() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationTlsNestedImpl<N>
    extends KafkaClientAuthenticationTlsFluentImpl<KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<N>>
    implements KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationTlsBuilder builder;

        KafkaClientAuthenticationTlsNestedImpl(KafkaClientAuthenticationTls item) {
            this.builder = new KafkaClientAuthenticationTlsBuilder(this, item);
        }

        KafkaClientAuthenticationTlsNestedImpl() {
            this.builder = new KafkaClientAuthenticationTlsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationTls() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationOAuthNestedImpl<N>
    extends KafkaClientAuthenticationOAuthFluentImpl<KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<N>>
    implements KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationOAuthBuilder builder;

        KafkaClientAuthenticationOAuthNestedImpl(KafkaClientAuthenticationOAuth item) {
            this.builder = new KafkaClientAuthenticationOAuthBuilder(this, item);
        }

        KafkaClientAuthenticationOAuthNestedImpl() {
            this.builder = new KafkaClientAuthenticationOAuthBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationOAuth() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationPlainNestedImpl<N>
    extends KafkaClientAuthenticationPlainFluentImpl<KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<N>>
    implements KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationPlainBuilder builder;

        KafkaClientAuthenticationPlainNestedImpl(KafkaClientAuthenticationPlain item) {
            this.builder = new KafkaClientAuthenticationPlainBuilder(this, item);
        }

        KafkaClientAuthenticationPlainNestedImpl() {
            this.builder = new KafkaClientAuthenticationPlainBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationPlain() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationScramSha512NestedImpl<N>
    extends KafkaClientAuthenticationScramSha512FluentImpl<KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>>
    implements KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationScramSha512Builder builder;

        KafkaClientAuthenticationScramSha512NestedImpl(KafkaClientAuthenticationScramSha512 item) {
            this.builder = new KafkaClientAuthenticationScramSha512Builder(this, item);
        }

        KafkaClientAuthenticationScramSha512NestedImpl() {
            this.builder = new KafkaClientAuthenticationScramSha512Builder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationScramSha512() {
            return this.and();
        }
    }

    public class TlsNestedImpl<N>
    extends KafkaBridgeTlsFluentImpl<KafkaBridgeSpecFluent.TlsNested<N>>
    implements KafkaBridgeSpecFluent.TlsNested<N>,
    Nested<N> {
        private final KafkaBridgeTlsBuilder builder;

        TlsNestedImpl(KafkaBridgeTls item) {
            this.builder = new KafkaBridgeTlsBuilder(this, item);
        }

        TlsNestedImpl() {
            this.builder = new KafkaBridgeTlsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withTls(this.builder.build());
        }

        @Override
        public N endTls() {
            return this.and();
        }
    }

    public class HttpNestedImpl<N>
    extends KafkaBridgeHttpConfigFluentImpl<KafkaBridgeSpecFluent.HttpNested<N>>
    implements KafkaBridgeSpecFluent.HttpNested<N>,
    Nested<N> {
        private final KafkaBridgeHttpConfigBuilder builder;

        HttpNestedImpl(KafkaBridgeHttpConfig item) {
            this.builder = new KafkaBridgeHttpConfigBuilder(this, item);
        }

        HttpNestedImpl() {
            this.builder = new KafkaBridgeHttpConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaBridgeSpecFluentImpl.this.withHttp(this.builder.build());
        }

        @Override
        public N endHttp() {
            return this.and();
        }
    }
}

