/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaConnector;
import io.strimzi.api.kafka.model.KafkaConnectorFluent;
import io.strimzi.api.kafka.model.KafkaConnectorFluentImpl;
import java.util.Objects;

public class KafkaConnectorBuilder
extends KafkaConnectorFluentImpl<KafkaConnectorBuilder>
implements VisitableBuilder<KafkaConnector, KafkaConnectorBuilder> {
    KafkaConnectorFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectorBuilder() {
        this(true);
    }

    public KafkaConnectorBuilder(Boolean validationEnabled) {
        this(new KafkaConnector(), validationEnabled);
    }

    public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaConnector(), validationEnabled);
    }

    public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent, KafkaConnector instance) {
        this(fluent, instance, true);
    }

    public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent, KafkaConnector instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withMetadata(instance.getMetadata());
        fluent.withApiVersion(instance.getApiVersion());
        this.validationEnabled = validationEnabled;
    }

    public KafkaConnectorBuilder(KafkaConnector instance) {
        this(instance, (Boolean)true);
    }

    public KafkaConnectorBuilder(KafkaConnector instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withMetadata(instance.getMetadata());
        this.withApiVersion(instance.getApiVersion());
        this.validationEnabled = validationEnabled;
    }

    public KafkaConnector build() {
        KafkaConnector buildable = new KafkaConnector();
        buildable.setSpec(this.fluent.getSpec());
        buildable.setStatus(this.fluent.getStatus());
        buildable.setMetadata(this.fluent.getMetadata());
        buildable.setApiVersion(this.fluent.getApiVersion());
        buildable.setKind(this.fluent.getKind());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConnectorBuilder that = (KafkaConnectorBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

