/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpec;
import io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpecFluent;
import io.strimzi.api.kafka.model.KafkaMirrorMakerTls;
import io.strimzi.api.kafka.model.KafkaMirrorMakerTlsBuilder;
import io.strimzi.api.kafka.model.KafkaMirrorMakerTlsFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class KafkaMirrorMakerClientSpecFluentImpl<A extends KafkaMirrorMakerClientSpecFluent<A>>
extends BaseFluent<A>
implements KafkaMirrorMakerClientSpecFluent<A> {
    private String bootstrapServers;
    private Map<String, Object> config;
    private KafkaMirrorMakerTlsBuilder tls;
    private VisitableBuilder<? extends KafkaClientAuthentication, ?> authentication;

    public KafkaMirrorMakerClientSpecFluentImpl() {
    }

    public KafkaMirrorMakerClientSpecFluentImpl(KafkaMirrorMakerClientSpec instance) {
        this.withBootstrapServers(instance.getBootstrapServers());
        this.withConfig(instance.getConfig());
        this.withTls(instance.getTls());
        this.withAuthentication(instance.getAuthentication());
    }

    @Override
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Override
    public A withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return (A)this;
    }

    @Override
    public Boolean hasBootstrapServers() {
        return this.bootstrapServers != null;
    }

    @Override
    @Deprecated
    public A withNewBootstrapServers(String original) {
        return this.withBootstrapServers(new String(original));
    }

    @Override
    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)this;
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public <K, V> A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    @Deprecated
    public KafkaMirrorMakerTls getTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public KafkaMirrorMakerTls buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public A withTls(KafkaMirrorMakerTls tls) {
        this._visitables.get((Object)"tls").remove(this.tls);
        if (tls != null) {
            this.tls = new KafkaMirrorMakerTlsBuilder(tls);
            this._visitables.get((Object)"tls").add(this.tls);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return this.tls != null;
    }

    @Override
    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> withNewTls() {
        return new TlsNestedImpl();
    }

    @Override
    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> withNewTlsLike(KafkaMirrorMakerTls item) {
        return new TlsNestedImpl(item);
    }

    @Override
    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> editTls() {
        return this.withNewTlsLike(this.getTls());
    }

    @Override
    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : new KafkaMirrorMakerTlsBuilder().build());
    }

    @Override
    public KafkaMirrorMakerClientSpecFluent.TlsNested<A> editOrNewTlsLike(KafkaMirrorMakerTls item) {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : item);
    }

    @Override
    @Deprecated
    public KafkaClientAuthentication getAuthentication() {
        return this.authentication != null ? (KafkaClientAuthentication)this.authentication.build() : null;
    }

    @Override
    public KafkaClientAuthentication buildAuthentication() {
        return this.authentication != null ? (KafkaClientAuthentication)this.authentication.build() : null;
    }

    @Override
    public A withAuthentication(KafkaClientAuthentication authentication) {
        if (authentication instanceof KafkaClientAuthenticationScramSha512) {
            this.authentication = new KafkaClientAuthenticationScramSha512Builder((KafkaClientAuthenticationScramSha512)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        if (authentication instanceof KafkaClientAuthenticationPlain) {
            this.authentication = new KafkaClientAuthenticationPlainBuilder((KafkaClientAuthenticationPlain)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        if (authentication instanceof KafkaClientAuthenticationOAuth) {
            this.authentication = new KafkaClientAuthenticationOAuthBuilder((KafkaClientAuthenticationOAuth)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        if (authentication instanceof KafkaClientAuthenticationTls) {
            this.authentication = new KafkaClientAuthenticationTlsBuilder((KafkaClientAuthenticationTls)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthentication() {
        return this.authentication != null;
    }

    @Override
    public A withKafkaClientAuthenticationScramSha512(KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationScramSha512 != null) {
            this.authentication = new KafkaClientAuthenticationScramSha512Builder(kafkaClientAuthenticationScramSha512);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512() {
        return new KafkaClientAuthenticationScramSha512NestedImpl();
    }

    @Override
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item) {
        return new KafkaClientAuthenticationScramSha512NestedImpl(item);
    }

    @Override
    public A withKafkaClientAuthenticationPlain(KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationPlain != null) {
            this.authentication = new KafkaClientAuthenticationPlainBuilder(kafkaClientAuthenticationPlain);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain() {
        return new KafkaClientAuthenticationPlainNestedImpl();
    }

    @Override
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item) {
        return new KafkaClientAuthenticationPlainNestedImpl(item);
    }

    @Override
    public A withKafkaClientAuthenticationOAuth(KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationOAuth != null) {
            this.authentication = new KafkaClientAuthenticationOAuthBuilder(kafkaClientAuthenticationOAuth);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth() {
        return new KafkaClientAuthenticationOAuthNestedImpl();
    }

    @Override
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item) {
        return new KafkaClientAuthenticationOAuthNestedImpl(item);
    }

    @Override
    public A withKafkaClientAuthenticationTls(KafkaClientAuthenticationTls kafkaClientAuthenticationTls) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationTls != null) {
            this.authentication = new KafkaClientAuthenticationTlsBuilder(kafkaClientAuthenticationTls);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls() {
        return new KafkaClientAuthenticationTlsNestedImpl();
    }

    @Override
    public KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item) {
        return new KafkaClientAuthenticationTlsNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaMirrorMakerClientSpecFluentImpl that = (KafkaMirrorMakerClientSpecFluentImpl)o;
        if (this.bootstrapServers != null ? !this.bootstrapServers.equals(that.bootstrapServers) : that.bootstrapServers != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.tls != null ? !this.tls.equals(that.tls) : that.tls != null) {
            return false;
        }
        return !(this.authentication != null ? !this.authentication.equals(that.authentication) : that.authentication != null);
    }

    public int hashCode() {
        return Objects.hash(this.bootstrapServers, this.config, this.tls, this.authentication, super.hashCode());
    }

    public class KafkaClientAuthenticationTlsNestedImpl<N>
    extends KafkaClientAuthenticationTlsFluentImpl<KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<N>>
    implements KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationTlsNested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationTlsBuilder builder;

        KafkaClientAuthenticationTlsNestedImpl(KafkaClientAuthenticationTls item) {
            this.builder = new KafkaClientAuthenticationTlsBuilder(this, item);
        }

        KafkaClientAuthenticationTlsNestedImpl() {
            this.builder = new KafkaClientAuthenticationTlsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaMirrorMakerClientSpecFluentImpl.this.withAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationTls() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationOAuthNestedImpl<N>
    extends KafkaClientAuthenticationOAuthFluentImpl<KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<N>>
    implements KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationOAuthNested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationOAuthBuilder builder;

        KafkaClientAuthenticationOAuthNestedImpl(KafkaClientAuthenticationOAuth item) {
            this.builder = new KafkaClientAuthenticationOAuthBuilder(this, item);
        }

        KafkaClientAuthenticationOAuthNestedImpl() {
            this.builder = new KafkaClientAuthenticationOAuthBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaMirrorMakerClientSpecFluentImpl.this.withAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationOAuth() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationPlainNestedImpl<N>
    extends KafkaClientAuthenticationPlainFluentImpl<KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<N>>
    implements KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationPlainNested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationPlainBuilder builder;

        KafkaClientAuthenticationPlainNestedImpl(KafkaClientAuthenticationPlain item) {
            this.builder = new KafkaClientAuthenticationPlainBuilder(this, item);
        }

        KafkaClientAuthenticationPlainNestedImpl() {
            this.builder = new KafkaClientAuthenticationPlainBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaMirrorMakerClientSpecFluentImpl.this.withAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationPlain() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationScramSha512NestedImpl<N>
    extends KafkaClientAuthenticationScramSha512FluentImpl<KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>>
    implements KafkaMirrorMakerClientSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationScramSha512Builder builder;

        KafkaClientAuthenticationScramSha512NestedImpl(KafkaClientAuthenticationScramSha512 item) {
            this.builder = new KafkaClientAuthenticationScramSha512Builder(this, item);
        }

        KafkaClientAuthenticationScramSha512NestedImpl() {
            this.builder = new KafkaClientAuthenticationScramSha512Builder(this);
        }

        @Override
        public N and() {
            return (N)KafkaMirrorMakerClientSpecFluentImpl.this.withAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationScramSha512() {
            return this.and();
        }
    }

    public class TlsNestedImpl<N>
    extends KafkaMirrorMakerTlsFluentImpl<KafkaMirrorMakerClientSpecFluent.TlsNested<N>>
    implements KafkaMirrorMakerClientSpecFluent.TlsNested<N>,
    Nested<N> {
        private final KafkaMirrorMakerTlsBuilder builder;

        TlsNestedImpl(KafkaMirrorMakerTls item) {
            this.builder = new KafkaMirrorMakerTlsBuilder(this, item);
        }

        TlsNestedImpl() {
            this.builder = new KafkaMirrorMakerTlsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaMirrorMakerClientSpecFluentImpl.this.withTls(this.builder.build());
        }

        @Override
        public N endTls() {
            return this.and();
        }
    }
}

