/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.ZookeeperClusterSpec;
import io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent;
import io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl;
import java.util.Objects;

public class ZookeeperClusterSpecBuilder
extends ZookeeperClusterSpecFluentImpl<ZookeeperClusterSpecBuilder>
implements VisitableBuilder<ZookeeperClusterSpec, ZookeeperClusterSpecBuilder> {
    ZookeeperClusterSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ZookeeperClusterSpecBuilder() {
        this(true);
    }

    public ZookeeperClusterSpecBuilder(Boolean validationEnabled) {
        this(new ZookeeperClusterSpec(), validationEnabled);
    }

    public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ZookeeperClusterSpec(), validationEnabled);
    }

    public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent, ZookeeperClusterSpec instance) {
        this(fluent, instance, true);
    }

    public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent, ZookeeperClusterSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withStorage(instance.getStorage());
        fluent.withConfig(instance.getConfig());
        fluent.withLogging(instance.getLogging());
        fluent.withReplicas(instance.getReplicas());
        fluent.withImage(instance.getImage());
        fluent.withResources(instance.getResources());
        fluent.withLivenessProbe(instance.getLivenessProbe());
        fluent.withReadinessProbe(instance.getReadinessProbe());
        fluent.withJvmOptions(instance.getJvmOptions());
        fluent.withMetricsConfig(instance.getMetricsConfig());
        fluent.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public ZookeeperClusterSpecBuilder(ZookeeperClusterSpec instance) {
        this(instance, (Boolean)true);
    }

    public ZookeeperClusterSpecBuilder(ZookeeperClusterSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withStorage(instance.getStorage());
        this.withConfig(instance.getConfig());
        this.withLogging(instance.getLogging());
        this.withReplicas(instance.getReplicas());
        this.withImage(instance.getImage());
        this.withResources(instance.getResources());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withJvmOptions(instance.getJvmOptions());
        this.withMetricsConfig(instance.getMetricsConfig());
        this.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public ZookeeperClusterSpec build() {
        ZookeeperClusterSpec buildable = new ZookeeperClusterSpec();
        buildable.setStorage(this.fluent.getStorage());
        buildable.setConfig(this.fluent.getConfig());
        buildable.setLogging(this.fluent.getLogging());
        buildable.setReplicas(this.fluent.getReplicas());
        buildable.setImage(this.fluent.getImage());
        buildable.setResources(this.fluent.getResources());
        buildable.setLivenessProbe(this.fluent.getLivenessProbe());
        buildable.setReadinessProbe(this.fluent.getReadinessProbe());
        buildable.setJvmOptions(this.fluent.getJvmOptions());
        buildable.setMetricsConfig(this.fluent.getMetricsConfig());
        buildable.setTemplate(this.fluent.getTemplate());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ZookeeperClusterSpecBuilder that = (ZookeeperClusterSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

