/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.balancing;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Maximum;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.strimzi.crdgenerator.annotations.Pattern;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"disk", "cpuUtilization", "inboundNetwork", "outboundNetwork"})
public class BrokerCapacity
implements UnknownPropertyPreserving,
Serializable {
    private static final long serialVersionUID = 1L;
    private String disk;
    private Integer cpuUtilization;
    private String inboundNetwork;
    private String outboundNetwork;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @Pattern(value="^[0-9]+([.][0-9]*)?([KMGTPE]i?|e[0-9]+)?$")
    @Description(value="Broker capacity for disk in bytes, for example, 100Gi.")
    public String getDisk() {
        return this.disk;
    }

    public void setDisk(String disk) {
        this.disk = disk;
    }

    @Minimum(value=0)
    @Maximum(value=100)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="Broker capacity for CPU resource utilization as a percentage (0 - 100).")
    public Integer getCpuUtilization() {
        return this.cpuUtilization;
    }

    public void setCpuUtilization(Integer cpuUtilization) {
        this.cpuUtilization = cpuUtilization;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Pattern(value="[0-9]+([KMG]i?)?B/s")
    @Description(value="Broker capacity for inbound network throughput in bytes per second, for example, 10000KB/s")
    public String getInboundNetwork() {
        return this.inboundNetwork;
    }

    public void setInboundNetwork(String inboundNetwork) {
        this.inboundNetwork = inboundNetwork;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Pattern(value="[0-9]+([KMG]i?)?B/s")
    @Description(value="Broker capacity for outbound network throughput in bytes per second, for example 10000KB/s")
    public String getOutboundNetwork() {
        return this.outboundNetwork;
    }

    public void setOutboundNetwork(String outboundNetwork) {
        this.outboundNetwork = outboundNetwork;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerCapacity)) {
            return false;
        }
        BrokerCapacity other = (BrokerCapacity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$disk = this.getDisk();
        String other$disk = other.getDisk();
        if (this$disk == null ? other$disk != null : !this$disk.equals(other$disk)) {
            return false;
        }
        Integer this$cpuUtilization = this.getCpuUtilization();
        Integer other$cpuUtilization = other.getCpuUtilization();
        if (this$cpuUtilization == null ? other$cpuUtilization != null : !((Object)this$cpuUtilization).equals(other$cpuUtilization)) {
            return false;
        }
        String this$inboundNetwork = this.getInboundNetwork();
        String other$inboundNetwork = other.getInboundNetwork();
        if (this$inboundNetwork == null ? other$inboundNetwork != null : !this$inboundNetwork.equals(other$inboundNetwork)) {
            return false;
        }
        String this$outboundNetwork = this.getOutboundNetwork();
        String other$outboundNetwork = other.getOutboundNetwork();
        if (this$outboundNetwork == null ? other$outboundNetwork != null : !this$outboundNetwork.equals(other$outboundNetwork)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrokerCapacity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $disk = this.getDisk();
        result = result * 59 + ($disk == null ? 43 : $disk.hashCode());
        Integer $cpuUtilization = this.getCpuUtilization();
        result = result * 59 + ($cpuUtilization == null ? 43 : ((Object)$cpuUtilization).hashCode());
        String $inboundNetwork = this.getInboundNetwork();
        result = result * 59 + ($inboundNetwork == null ? 43 : $inboundNetwork.hashCode());
        String $outboundNetwork = this.getOutboundNetwork();
        result = result * 59 + ($outboundNetwork == null ? 43 : $outboundNetwork.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

