/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.connect.ConnectorPlugin;
import io.strimzi.api.kafka.model.connect.ConnectorPluginFluent;
import io.strimzi.api.kafka.model.connect.ConnectorPluginFluentImpl;
import java.util.Objects;

public class ConnectorPluginBuilder
extends ConnectorPluginFluentImpl<ConnectorPluginBuilder>
implements VisitableBuilder<ConnectorPlugin, ConnectorPluginBuilder> {
    ConnectorPluginFluent<?> fluent;
    Boolean validationEnabled;

    public ConnectorPluginBuilder() {
        this(true);
    }

    public ConnectorPluginBuilder(Boolean validationEnabled) {
        this(new ConnectorPlugin(), validationEnabled);
    }

    public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ConnectorPlugin(), validationEnabled);
    }

    public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent, ConnectorPlugin instance) {
        this(fluent, instance, true);
    }

    public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent, ConnectorPlugin instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConnectorClass(instance.getConnectorClass());
        fluent.withType(instance.getType());
        fluent.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public ConnectorPluginBuilder(ConnectorPlugin instance) {
        this(instance, (Boolean)true);
    }

    public ConnectorPluginBuilder(ConnectorPlugin instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConnectorClass(instance.getConnectorClass());
        this.withType(instance.getType());
        this.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public ConnectorPlugin build() {
        ConnectorPlugin buildable = new ConnectorPlugin();
        buildable.setConnectorClass(this.fluent.getConnectorClass());
        buildable.setType(this.fluent.getType());
        buildable.setVersion(this.fluent.getVersion());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConnectorPluginBuilder that = (ConnectorPluginBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

